@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.GetLedgerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ledgerName Name of the Confidential Ledger
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLedgerPlainArgs(
    public val ledgerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.GetLedgerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.GetLedgerPlainArgs =
        com.pulumi.azurenative.confidentialledger.inputs.GetLedgerPlainArgs.builder()
            .ledgerName(ledgerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLedgerPlainArgs].
 */
@PulumiTagMarker
public class GetLedgerPlainArgsBuilder internal constructor() {
    private var ledgerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Confidential Ledger
     */
    @JvmName("cqfalrfgxlywroqk")
    public suspend fun ledgerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ledgerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("epqhhjiuukknrswq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLedgerPlainArgs = GetLedgerPlainArgs(
        ledgerName = ledgerName ?: throw PulumiNullFieldException("ledgerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
