@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confidentialledger.kotlin.inputs

import com.pulumi.azurenative.confidentialledger.inputs.LedgerPropertiesArgs.builder
import com.pulumi.azurenative.confidentialledger.kotlin.enums.LedgerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Additional Confidential Ledger properties.
 * @property aadBasedSecurityPrincipals Array of all AAD based Security Principals.
 * @property certBasedSecurityPrincipals Array of all cert based Security Principals.
 * @property ledgerType Type of Confidential Ledger
 */
public data class LedgerPropertiesArgs(
    public val aadBasedSecurityPrincipals: Output<List<AADBasedSecurityPrincipalArgs>>? = null,
    public val certBasedSecurityPrincipals: Output<List<CertBasedSecurityPrincipalArgs>>? = null,
    public val ledgerType: Output<Either<String, LedgerType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confidentialledger.inputs.LedgerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.confidentialledger.inputs.LedgerPropertiesArgs =
        com.pulumi.azurenative.confidentialledger.inputs.LedgerPropertiesArgs.builder()
            .aadBasedSecurityPrincipals(
                aadBasedSecurityPrincipals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .certBasedSecurityPrincipals(
                certBasedSecurityPrincipals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ledgerType(
                ledgerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LedgerPropertiesArgs].
 */
@PulumiTagMarker
public class LedgerPropertiesArgsBuilder internal constructor() {
    private var aadBasedSecurityPrincipals: Output<List<AADBasedSecurityPrincipalArgs>>? = null

    private var certBasedSecurityPrincipals: Output<List<CertBasedSecurityPrincipalArgs>>? = null

    private var ledgerType: Output<Either<String, LedgerType>>? = null

    /**
     * @param value Array of all AAD based Security Principals.
     */
    @JvmName("xgrtacpihivvxayr")
    public suspend
    fun aadBasedSecurityPrincipals(`value`: Output<List<AADBasedSecurityPrincipalArgs>>) {
        this.aadBasedSecurityPrincipals = value
    }

    @JvmName("sgumuufxrbxylfhm")
    public suspend fun aadBasedSecurityPrincipals(
        vararg
        values: Output<AADBasedSecurityPrincipalArgs>,
    ) {
        this.aadBasedSecurityPrincipals = Output.all(values.asList())
    }

    /**
     * @param values Array of all AAD based Security Principals.
     */
    @JvmName("assbmwhbtkwsokiv")
    public suspend
    fun aadBasedSecurityPrincipals(values: List<Output<AADBasedSecurityPrincipalArgs>>) {
        this.aadBasedSecurityPrincipals = Output.all(values)
    }

    /**
     * @param value Array of all cert based Security Principals.
     */
    @JvmName("dlusckklenpyqvgv")
    public suspend
    fun certBasedSecurityPrincipals(`value`: Output<List<CertBasedSecurityPrincipalArgs>>) {
        this.certBasedSecurityPrincipals = value
    }

    @JvmName("jcnucdckvscwqukx")
    public suspend fun certBasedSecurityPrincipals(
        vararg
        values: Output<CertBasedSecurityPrincipalArgs>,
    ) {
        this.certBasedSecurityPrincipals = Output.all(values.asList())
    }

    /**
     * @param values Array of all cert based Security Principals.
     */
    @JvmName("qdepufrxeslyxemi")
    public suspend
    fun certBasedSecurityPrincipals(values: List<Output<CertBasedSecurityPrincipalArgs>>) {
        this.certBasedSecurityPrincipals = Output.all(values)
    }

    /**
     * @param value Type of Confidential Ledger
     */
    @JvmName("kljomrpvftvfprhr")
    public suspend fun ledgerType(`value`: Output<Either<String, LedgerType>>) {
        this.ledgerType = value
    }

    /**
     * @param value Array of all AAD based Security Principals.
     */
    @JvmName("vndnfpoctequlryh")
    public suspend fun aadBasedSecurityPrincipals(`value`: List<AADBasedSecurityPrincipalArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all AAD based Security Principals.
     */
    @JvmName("tlnhcnfgakwgoffv")
    public suspend
    fun aadBasedSecurityPrincipals(argument: List<suspend AADBasedSecurityPrincipalArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AADBasedSecurityPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.aadBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all AAD based Security Principals.
     */
    @JvmName("tydynudmhaslxovu")
    public suspend fun aadBasedSecurityPrincipals(
        vararg
        argument: suspend AADBasedSecurityPrincipalArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AADBasedSecurityPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.aadBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all AAD based Security Principals.
     */
    @JvmName("tcrfmandsvgevfnv")
    public suspend
    fun aadBasedSecurityPrincipals(argument: suspend AADBasedSecurityPrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AADBasedSecurityPrincipalArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.aadBasedSecurityPrincipals = mapped
    }

    /**
     * @param values Array of all AAD based Security Principals.
     */
    @JvmName("oqtojfrnojqjxdpj")
    public suspend fun aadBasedSecurityPrincipals(vararg values: AADBasedSecurityPrincipalArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aadBasedSecurityPrincipals = mapped
    }

    /**
     * @param value Array of all cert based Security Principals.
     */
    @JvmName("qmaecgsueggrypnd")
    public suspend fun certBasedSecurityPrincipals(`value`: List<CertBasedSecurityPrincipalArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all cert based Security Principals.
     */
    @JvmName("qpgemgwxtnlpftbg")
    public suspend
    fun certBasedSecurityPrincipals(argument: List<suspend CertBasedSecurityPrincipalArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CertBasedSecurityPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all cert based Security Principals.
     */
    @JvmName("xivddqieayjdcqon")
    public suspend fun certBasedSecurityPrincipals(
        vararg
        argument: suspend CertBasedSecurityPrincipalArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CertBasedSecurityPrincipalArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certBasedSecurityPrincipals = mapped
    }

    /**
     * @param argument Array of all cert based Security Principals.
     */
    @JvmName("hwjvwcmjxnhgvafw")
    public suspend
    fun certBasedSecurityPrincipals(argument: suspend CertBasedSecurityPrincipalArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CertBasedSecurityPrincipalArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.certBasedSecurityPrincipals = mapped
    }

    /**
     * @param values Array of all cert based Security Principals.
     */
    @JvmName("yvgatlxirlhylgch")
    public suspend fun certBasedSecurityPrincipals(vararg values: CertBasedSecurityPrincipalArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certBasedSecurityPrincipals = mapped
    }

    /**
     * @param value Type of Confidential Ledger
     */
    @JvmName("vunigqllllqlybnm")
    public suspend fun ledgerType(`value`: Either<String, LedgerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ledgerType = mapped
    }

    /**
     * @param value Type of Confidential Ledger
     */
    @JvmName("oabomfmlsfpfkrpc")
    public fun ledgerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LedgerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerType = mapped
    }

    /**
     * @param value Type of Confidential Ledger
     */
    @JvmName("mvhksqwsehaycnka")
    public fun ledgerType(`value`: LedgerType) {
        val toBeMapped = Either.ofRight<String, LedgerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ledgerType = mapped
    }

    internal fun build(): LedgerPropertiesArgs = LedgerPropertiesArgs(
        aadBasedSecurityPrincipals = aadBasedSecurityPrincipals,
        certBasedSecurityPrincipals = certBasedSecurityPrincipals,
        ledgerType = ledgerType,
    )
}
