@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin

import com.pulumi.azurenative.confluent.ConfluentFunctions.getOrganizationPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessClustersPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessEnvironmentsPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessInvitationsPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessRoleBindingNamePlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessRoleBindingsPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessServiceAccountsPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listAccessUsersPlain
import com.pulumi.azurenative.confluent.ConfluentFunctions.listOrganizationRegionsPlain
import com.pulumi.azurenative.confluent.kotlin.inputs.GetOrganizationPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.GetOrganizationPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessClustersPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessClustersPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessEnvironmentsPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessEnvironmentsPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessInvitationsPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessInvitationsPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessRoleBindingNamePlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessRoleBindingNamePlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessRoleBindingsPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessRoleBindingsPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessServiceAccountsPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessServiceAccountsPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessUsersPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListAccessUsersPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.inputs.ListOrganizationRegionsPlainArgs
import com.pulumi.azurenative.confluent.kotlin.inputs.ListOrganizationRegionsPlainArgsBuilder
import com.pulumi.azurenative.confluent.kotlin.outputs.GetOrganizationResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessClustersResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessEnvironmentsResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessInvitationsResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessRoleBindingNameResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessRoleBindingsResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessServiceAccountsResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessUsersResult
import com.pulumi.azurenative.confluent.kotlin.outputs.ListOrganizationRegionsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.confluent.kotlin.outputs.GetOrganizationResult.Companion.toKotlin as getOrganizationResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessClustersResult.Companion.toKotlin as listAccessClustersResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessEnvironmentsResult.Companion.toKotlin as listAccessEnvironmentsResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessInvitationsResult.Companion.toKotlin as listAccessInvitationsResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessRoleBindingNameResult.Companion.toKotlin as listAccessRoleBindingNameResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessRoleBindingsResult.Companion.toKotlin as listAccessRoleBindingsResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessServiceAccountsResult.Companion.toKotlin as listAccessServiceAccountsResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListAccessUsersResult.Companion.toKotlin as listAccessUsersResultToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.ListOrganizationRegionsResult.Companion.toKotlin as listOrganizationRegionsResultToKotlin

public object ConfluentFunctions {
    /**
     * Organization resource.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2020-03-01-preview, 2023-08-22, 2024-02-13.
     * @param argument null
     * @return Organization resource.
     */
    public suspend fun getOrganization(argument: GetOrganizationPlainArgs): GetOrganizationResult =
        getOrganizationResultToKotlin(getOrganizationPlain(argument.toJava()).await())

    /**
     * @see [getOrganization].
     * @param organizationName Organization resource name
     * @param resourceGroupName Resource group name
     * @return Organization resource.
     */
    public suspend fun getOrganization(organizationName: String, resourceGroupName: String):
        GetOrganizationResult {
        val argument = GetOrganizationPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
        )
        return getOrganizationResultToKotlin(getOrganizationPlain(argument.toJava()).await())
    }

    /**
     * @see [getOrganization].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;GetOrganizationPlainArgs].
     * @return Organization resource.
     */
    public suspend fun getOrganization(argument: suspend GetOrganizationPlainArgsBuilder.() -> Unit):
        GetOrganizationResult {
        val builder = GetOrganizationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrganizationResultToKotlin(getOrganizationPlain(builtArgument.toJava()).await())
    }

    /**
     * List cluster success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List cluster success response
     */
    public suspend fun listAccessClusters(argument: ListAccessClustersPlainArgs):
        ListAccessClustersResult =
        listAccessClustersResultToKotlin(listAccessClustersPlain(argument.toJava()).await())

    /**
     * @see [listAccessClusters].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List cluster success response
     */
    public suspend fun listAccessClusters(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessClustersResult {
        val argument = ListAccessClustersPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessClustersResultToKotlin(listAccessClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessClusters].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessClustersPlainArgs].
     * @return List cluster success response
     */
    public suspend
    fun listAccessClusters(argument: suspend ListAccessClustersPlainArgsBuilder.() -> Unit):
        ListAccessClustersResult {
        val builder = ListAccessClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessClustersResultToKotlin(listAccessClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * List environments success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List environments success response
     */
    public suspend fun listAccessEnvironments(argument: ListAccessEnvironmentsPlainArgs):
        ListAccessEnvironmentsResult =
        listAccessEnvironmentsResultToKotlin(listAccessEnvironmentsPlain(argument.toJava()).await())

    /**
     * @see [listAccessEnvironments].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List environments success response
     */
    public suspend fun listAccessEnvironments(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessEnvironmentsResult {
        val argument = ListAccessEnvironmentsPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessEnvironmentsResultToKotlin(listAccessEnvironmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessEnvironments].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessEnvironmentsPlainArgs].
     * @return List environments success response
     */
    public suspend
    fun listAccessEnvironments(argument: suspend ListAccessEnvironmentsPlainArgsBuilder.() -> Unit):
        ListAccessEnvironmentsResult {
        val builder = ListAccessEnvironmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessEnvironmentsResultToKotlin(listAccessEnvironmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * List invitations success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List invitations success response
     */
    public suspend fun listAccessInvitations(argument: ListAccessInvitationsPlainArgs):
        ListAccessInvitationsResult =
        listAccessInvitationsResultToKotlin(listAccessInvitationsPlain(argument.toJava()).await())

    /**
     * @see [listAccessInvitations].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List invitations success response
     */
    public suspend fun listAccessInvitations(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessInvitationsResult {
        val argument = ListAccessInvitationsPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessInvitationsResultToKotlin(listAccessInvitationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessInvitations].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessInvitationsPlainArgs].
     * @return List invitations success response
     */
    public suspend
    fun listAccessInvitations(argument: suspend ListAccessInvitationsPlainArgsBuilder.() -> Unit):
        ListAccessInvitationsResult {
        val builder = ListAccessInvitationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessInvitationsResultToKotlin(listAccessInvitationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Details of the role binding names returned on successful response
     * Azure REST API version: 2024-02-13.
     * @param argument null
     * @return Details of the role binding names returned on successful response
     */
    public suspend fun listAccessRoleBindingName(argument: ListAccessRoleBindingNamePlainArgs):
        ListAccessRoleBindingNameResult =
        listAccessRoleBindingNameResultToKotlin(listAccessRoleBindingNamePlain(argument.toJava()).await())

    /**
     * @see [listAccessRoleBindingName].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return Details of the role binding names returned on successful response
     */
    public suspend fun listAccessRoleBindingName(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessRoleBindingNameResult {
        val argument = ListAccessRoleBindingNamePlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessRoleBindingNameResultToKotlin(listAccessRoleBindingNamePlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessRoleBindingName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessRoleBindingNamePlainArgs].
     * @return Details of the role binding names returned on successful response
     */
    public suspend
    fun listAccessRoleBindingName(argument: suspend ListAccessRoleBindingNamePlainArgsBuilder.() -> Unit):
        ListAccessRoleBindingNameResult {
        val builder = ListAccessRoleBindingNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessRoleBindingNameResultToKotlin(listAccessRoleBindingNamePlain(builtArgument.toJava()).await())
    }

    /**
     * List cluster success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List cluster success response
     */
    public suspend fun listAccessRoleBindings(argument: ListAccessRoleBindingsPlainArgs):
        ListAccessRoleBindingsResult =
        listAccessRoleBindingsResultToKotlin(listAccessRoleBindingsPlain(argument.toJava()).await())

    /**
     * @see [listAccessRoleBindings].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List cluster success response
     */
    public suspend fun listAccessRoleBindings(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessRoleBindingsResult {
        val argument = ListAccessRoleBindingsPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessRoleBindingsResultToKotlin(listAccessRoleBindingsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessRoleBindings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessRoleBindingsPlainArgs].
     * @return List cluster success response
     */
    public suspend
    fun listAccessRoleBindings(argument: suspend ListAccessRoleBindingsPlainArgsBuilder.() -> Unit):
        ListAccessRoleBindingsResult {
        val builder = ListAccessRoleBindingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessRoleBindingsResultToKotlin(listAccessRoleBindingsPlain(builtArgument.toJava()).await())
    }

    /**
     * List service accounts success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List service accounts success response
     */
    public suspend fun listAccessServiceAccounts(argument: ListAccessServiceAccountsPlainArgs):
        ListAccessServiceAccountsResult =
        listAccessServiceAccountsResultToKotlin(listAccessServiceAccountsPlain(argument.toJava()).await())

    /**
     * @see [listAccessServiceAccounts].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List service accounts success response
     */
    public suspend fun listAccessServiceAccounts(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessServiceAccountsResult {
        val argument = ListAccessServiceAccountsPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessServiceAccountsResultToKotlin(listAccessServiceAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessServiceAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessServiceAccountsPlainArgs].
     * @return List service accounts success response
     */
    public suspend
    fun listAccessServiceAccounts(argument: suspend ListAccessServiceAccountsPlainArgsBuilder.() -> Unit):
        ListAccessServiceAccountsResult {
        val builder = ListAccessServiceAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessServiceAccountsResultToKotlin(listAccessServiceAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * List users success response
     * Azure REST API version: 2023-08-22.
     * Other available API versions: 2024-02-13.
     * @param argument null
     * @return List users success response
     */
    public suspend fun listAccessUsers(argument: ListAccessUsersPlainArgs): ListAccessUsersResult =
        listAccessUsersResultToKotlin(listAccessUsersPlain(argument.toJava()).await())

    /**
     * @see [listAccessUsers].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return List users success response
     */
    public suspend fun listAccessUsers(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListAccessUsersResult {
        val argument = ListAccessUsersPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listAccessUsersResultToKotlin(listAccessUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccessUsers].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListAccessUsersPlainArgs].
     * @return List users success response
     */
    public suspend fun listAccessUsers(argument: suspend ListAccessUsersPlainArgsBuilder.() -> Unit):
        ListAccessUsersResult {
        val builder = ListAccessUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccessUsersResultToKotlin(listAccessUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * Result of POST request to list regions supported by confluent
     * Azure REST API version: 2024-02-13.
     * @param argument null
     * @return Result of POST request to list regions supported by confluent
     */
    public suspend fun listOrganizationRegions(argument: ListOrganizationRegionsPlainArgs):
        ListOrganizationRegionsResult =
        listOrganizationRegionsResultToKotlin(listOrganizationRegionsPlain(argument.toJava()).await())

    /**
     * @see [listOrganizationRegions].
     * @param organizationName Organization resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param searchFilters Search filters for the request
     * @return Result of POST request to list regions supported by confluent
     */
    public suspend fun listOrganizationRegions(
        organizationName: String,
        resourceGroupName: String,
        searchFilters: Map<String, String>? = null,
    ): ListOrganizationRegionsResult {
        val argument = ListOrganizationRegionsPlainArgs(
            organizationName = organizationName,
            resourceGroupName = resourceGroupName,
            searchFilters = searchFilters,
        )
        return listOrganizationRegionsResultToKotlin(listOrganizationRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [listOrganizationRegions].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;confluent&#46;kotlin&#46;inputs&#46;ListOrganizationRegionsPlainArgs].
     * @return Result of POST request to list regions supported by confluent
     */
    public suspend
    fun listOrganizationRegions(argument: suspend ListOrganizationRegionsPlainArgsBuilder.() -> Unit):
        ListOrganizationRegionsResult {
        val builder = ListOrganizationRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOrganizationRegionsResultToKotlin(listOrganizationRegionsPlain(builtArgument.toJava()).await())
    }
}
