@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin

import com.pulumi.azurenative.confluent.kotlin.outputs.OfferDetailResponse
import com.pulumi.azurenative.confluent.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.confluent.kotlin.outputs.UserDetailResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.confluent.kotlin.outputs.OfferDetailResponse.Companion.toKotlin as offerDetailResponseToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.confluent.kotlin.outputs.UserDetailResponse.Companion.toKotlin as userDetailResponseToKotlin

/**
 * Builder for [Organization].
 */
@PulumiTagMarker
public class OrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationArgs = OrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationArgsBuilder.() -> Unit) {
        val builder = OrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Organization {
        val builtJavaResource = com.pulumi.azurenative.confluent.Organization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Organization(builtJavaResource)
    }
}

/**
 * Organization resource.
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2020-03-01-preview, 2023-08-22, 2024-02-13.
 * ## Example Usage
 * ### Organization_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var organization = new AzureNative.Confluent.Organization("organization", new()
 *     {
 *         Location = "West US",
 *         OfferDetail = new AzureNative.Confluent.Inputs.OfferDetailArgs
 *         {
 *             Id = "string",
 *             PlanId = "string",
 *             PlanName = "string",
 *             PublisherId = "string",
 *             TermUnit = "string",
 *         },
 *         OrganizationName = "myOrganization",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "Environment", "Dev" },
 *         },
 *         UserDetail = new AzureNative.Confluent.Inputs.UserDetailArgs
 *         {
 *             EmailAddress = "contoso@microsoft.com",
 *             FirstName = "string",
 *             LastName = "string",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/confluent/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := confluent.NewOrganization(ctx, "organization", &confluent.OrganizationArgs{
 * 			Location: pulumi.String("West US"),
 * 			OfferDetail: &confluent.OfferDetailArgs{
 * 				Id:          pulumi.String("string"),
 * 				PlanId:      pulumi.String("string"),
 * 				PlanName:    pulumi.String("string"),
 * 				PublisherId: pulumi.String("string"),
 * 				TermUnit:    pulumi.String("string"),
 * 			},
 * 			OrganizationName:  pulumi.String("myOrganization"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 			UserDetail: &confluent.UserDetailArgs{
 * 				EmailAddress: pulumi.String("contoso@microsoft.com"),
 * 				FirstName:    pulumi.String("string"),
 * 				LastName:     pulumi.String("string"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.confluent.Organization;
 * import com.pulumi.azurenative.confluent.OrganizationArgs;
 * import com.pulumi.azurenative.confluent.inputs.OfferDetailArgs;
 * import com.pulumi.azurenative.confluent.inputs.UserDetailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var organization = new Organization("organization", OrganizationArgs.builder()
 *             .location("West US")
 *             .offerDetail(OfferDetailArgs.builder()
 *                 .id("string")
 *                 .planId("string")
 *                 .planName("string")
 *                 .publisherId("string")
 *                 .termUnit("string")
 *                 .build())
 *             .organizationName("myOrganization")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("Environment", "Dev"))
 *             .userDetail(UserDetailArgs.builder()
 *                 .emailAddress("contoso@microsoft.com")
 *                 .firstName("string")
 *                 .lastName("string")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:confluent:Organization myOrganization /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}
 * ```
 */
public class Organization internal constructor(
    override val javaResource: com.pulumi.azurenative.confluent.Organization,
) : KotlinCustomResource(javaResource, OrganizationMapper) {
    /**
     * The creation time of the resource.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Location of Organization resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Confluent offer detail
     */
    public val offerDetail: Output<OfferDetailResponse>
        get() = javaResource.offerDetail().applyValue({ args0 ->
            args0.let({ args0 ->
                offerDetailResponseToKotlin(args0)
            })
        })

    /**
     * Id of the Confluent organization.
     */
    public val organizationId: Output<String>
        get() = javaResource.organizationId().applyValue({ args0 -> args0 })

    /**
     * Provision states for confluent RP
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SSO url for the Confluent organization.
     */
    public val ssoUrl: Output<String>
        get() = javaResource.ssoUrl().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Organization resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Subscriber detail
     */
    public val userDetail: Output<UserDetailResponse>
        get() = javaResource.userDetail().applyValue({ args0 ->
            args0.let({ args0 ->
                userDetailResponseToKotlin(args0)
            })
        })
}

public object OrganizationMapper : ResourceMapper<Organization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.confluent.Organization::class == javaResource::class

    override fun map(javaResource: Resource): Organization = Organization(
        javaResource as
            com.pulumi.azurenative.confluent.Organization,
    )
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Organization].
 */
public suspend fun organization(
    name: String,
    block: suspend OrganizationResourceBuilder.() -> Unit,
): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Organization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organization(name: String): Organization {
    val builder = OrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
