@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.inputs

import com.pulumi.azurenative.confluent.inputs.ListAccessInvitationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property organizationName Organization resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property searchFilters Search filters for the request
 */
public data class ListAccessInvitationsPlainArgs(
    public val organizationName: String,
    public val resourceGroupName: String,
    public val searchFilters: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.confluent.inputs.ListAccessInvitationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.confluent.inputs.ListAccessInvitationsPlainArgs =
        com.pulumi.azurenative.confluent.inputs.ListAccessInvitationsPlainArgs.builder()
            .organizationName(organizationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .searchFilters(
                searchFilters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ListAccessInvitationsPlainArgs].
 */
@PulumiTagMarker
public class ListAccessInvitationsPlainArgsBuilder internal constructor() {
    private var organizationName: String? = null

    private var resourceGroupName: String? = null

    private var searchFilters: Map<String, String>? = null

    /**
     * @param value Organization resource name
     */
    @JvmName("skaxbycbuncybnva")
    public suspend fun organizationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.organizationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwommdrleqgvdujk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Search filters for the request
     */
    @JvmName("rtpjifudlcmjblrj")
    public suspend fun searchFilters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchFilters = mapped
    }

    /**
     * @param values Search filters for the request
     */
    @JvmName("ucvnhdvindexcqyb")
    public fun searchFilters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.searchFilters = mapped
    }

    internal fun build(): ListAccessInvitationsPlainArgs = ListAccessInvitationsPlainArgs(
        organizationName = organizationName ?: throw PulumiNullFieldException("organizationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        searchFilters = searchFilters,
    )
}
