@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of the role binding names returned on successful response
 * @property data List of role binding names
 * @property kind Type of response
 * @property metadata Metadata of the list
 */
public data class ListAccessRoleBindingNameResult(
    public val `data`: List<String>? = null,
    public val kind: String? = null,
    public val metadata: ConfluentListMetadataResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ListAccessRoleBindingNameResult):
            ListAccessRoleBindingNameResult = ListAccessRoleBindingNameResult(
            `data` = javaType.`data`().map({ args0 -> args0 }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ConfluentListMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
