@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List users success response
 * @property data Data of the users list
 * @property kind Type of response
 * @property metadata Metadata of the list
 */
public data class ListAccessUsersResult(
    public val `data`: List<UserRecordResponse>? = null,
    public val kind: String? = null,
    public val metadata: ConfluentListMetadataResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.ListAccessUsersResult):
            ListAccessUsersResult = ListAccessUsersResult(
            `data` = javaType.`data`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.UserRecordResponse.Companion.toKotlin(args0)
                })
            }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.ConfluentListMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
