@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of region record
 * @property id Id of the cluster
 * @property kind Kind of the cluster
 * @property metadata Metadata of the record
 * @property spec Specification of the region
 */
public data class RegionRecordResponse(
    public val id: String? = null,
    public val kind: String? = null,
    public val metadata: SCMetadataEntityResponse? = null,
    public val spec: RegionSpecEntityResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.RegionRecordResponse):
            RegionRecordResponse = RegionRecordResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.SCMetadataEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            spec = javaType.spec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.confluent.kotlin.outputs.RegionSpecEntityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
