@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Region spec details
 * @property cloud Cloud provider name
 * @property name Display Name of the region
 * @property packages
 * @property regionName Region name
 */
public data class RegionSpecEntityResponse(
    public val cloud: String? = null,
    public val name: String? = null,
    public val packages: List<String>? = null,
    public val regionName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.RegionSpecEntityResponse):
            RegionSpecEntityResponse = RegionSpecEntityResponse(
            cloud = javaType.cloud().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            packages = javaType.packages().map({ args0 -> args0 }),
            regionName = javaType.regionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
