@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata of the data record
 * @property createdTimestamp Created Date Time
 * @property deletedTimestamp Deleted Date time
 * @property resourceName Resource name of the record
 * @property self Self lookup url
 * @property updatedTimestamp Updated Date time
 */
public data class SCMetadataEntityResponse(
    public val createdTimestamp: String? = null,
    public val deletedTimestamp: String? = null,
    public val resourceName: String? = null,
    public val self: String? = null,
    public val updatedTimestamp: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.SCMetadataEntityResponse):
            SCMetadataEntityResponse = SCMetadataEntityResponse(
            createdTimestamp = javaType.createdTimestamp().map({ args0 -> args0 }).orElse(null),
            deletedTimestamp = javaType.deletedTimestamp().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            self = javaType.self().map({ args0 -> args0 }).orElse(null),
            updatedTimestamp = javaType.updatedTimestamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
