@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.confluent.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Subscriber detail
 * @property emailAddress Email address
 * @property firstName First name
 * @property lastName Last name
 */
public data class UserDetailResponse(
    public val emailAddress: String,
    public val firstName: String? = null,
    public val lastName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.confluent.outputs.UserDetailResponse):
            UserDetailResponse = UserDetailResponse(
            emailAddress = javaType.emailAddress(),
            firstName = javaType.firstName().map({ args0 -> args0 }).orElse(null),
            lastName = javaType.lastName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
