@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatumArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the HybridIdentityMetadata.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### CreateHybridIdentityMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridIdentityMetadatum = new AzureNative.ConnectedVMwarevSphere.HybridIdentityMetadatum("hybridIdentityMetadatum", new()
 *     {
 *         MetadataName = "default",
 *         PublicKey = "8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2",
 *         ResourceGroupName = "testrg",
 *         VirtualMachineName = "ContosoVm",
 *         VmId = "f8b82dff-38ef-4220-99ef-d3a3f86ddc6c",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewHybridIdentityMetadatum(ctx, "hybridIdentityMetadatum", &connectedvmwarevsphere.HybridIdentityMetadatumArgs{
 * 			MetadataName:       pulumi.String("default"),
 * 			PublicKey:          pulumi.String("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 			VmId:               pulumi.String("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatum;
 * import com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatumArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridIdentityMetadatum = new HybridIdentityMetadatum("hybridIdentityMetadatum", HybridIdentityMetadatumArgs.builder()
 *             .metadataName("default")
 *             .publicKey("8ec7d60c-9700-40b1-8e6e-e5b2f6f477f2")
 *             .resourceGroupName("testrg")
 *             .virtualMachineName("ContosoVm")
 *             .vmId("f8b82dff-38ef-4220-99ef-d3a3f86ddc6c")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:HybridIdentityMetadatum testItem /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachines/{virtualMachineName}/hybridIdentityMetadata/{metadataName}
 * ```
 * @property metadataName Name of the hybridIdentityMetadata.
 * @property publicKey Gets or sets the Public Key.
 * @property resourceGroupName The Resource Group Name.
 * @property virtualMachineName Name of the vm.
 * @property vmId Gets or sets the Vm Id.
 */
public data class HybridIdentityMetadatumArgs(
    public val metadataName: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
    public val vmId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatumArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatumArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.HybridIdentityMetadatumArgs.builder()
            .metadataName(metadataName?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 }))
            .vmId(vmId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridIdentityMetadatumArgs].
 */
@PulumiTagMarker
public class HybridIdentityMetadatumArgsBuilder internal constructor() {
    private var metadataName: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    private var vmId: Output<String>? = null

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("idxonpqrjneveoql")
    public suspend fun metadataName(`value`: Output<String>) {
        this.metadataName = value
    }

    /**
     * @param value Gets or sets the Public Key.
     */
    @JvmName("mgmkrujqhmoklkqr")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("aupibrcwdyiurogo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("inxrsipxlylmnnle")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Gets or sets the Vm Id.
     */
    @JvmName("xvkbiedagmvdvihl")
    public suspend fun vmId(`value`: Output<String>) {
        this.vmId = value
    }

    /**
     * @param value Name of the hybridIdentityMetadata.
     */
    @JvmName("xlmqpgdmgjrtdpqp")
    public suspend fun metadataName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataName = mapped
    }

    /**
     * @param value Gets or sets the Public Key.
     */
    @JvmName("kvuvrflcjguiuvdf")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("jraaoxgpqcrqegty")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("hipsjiujjbbdpntp")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    /**
     * @param value Gets or sets the Vm Id.
     */
    @JvmName("mxqxjediulybsmah")
    public suspend fun vmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmId = mapped
    }

    internal fun build(): HybridIdentityMetadatumArgs = HybridIdentityMetadatumArgs(
        metadataName = metadataName,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        virtualMachineName = virtualMachineName,
        vmId = vmId,
    )
}
