@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.InventoryItemArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.InventoryType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the inventory item.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateInventoryItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inventoryItem = new AzureNative.ConnectedVMwarevSphere.InventoryItem("inventoryItem", new()
 *     {
 *         InventoryItemName = "testItem",
 *         InventoryType = AzureNative.ConnectedVMwarevSphere.InventoryType.ResourcePool,
 *         ResourceGroupName = "testrg",
 *         VcenterName = "ContosoVCenter",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewInventoryItem(ctx, "inventoryItem", &connectedvmwarevsphere.InventoryItemArgs{
 * 			InventoryItemName: pulumi.String("testItem"),
 * 			InventoryType:     pulumi.String(connectedvmwarevsphere.InventoryTypeResourcePool),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VcenterName:       pulumi.String("ContosoVCenter"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.InventoryItem;
 * import com.pulumi.azurenative.connectedvmwarevsphere.InventoryItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inventoryItem = new InventoryItem("inventoryItem", InventoryItemArgs.builder()
 *             .inventoryItemName("testItem")
 *             .inventoryType("ResourcePool")
 *             .resourceGroupName("testrg")
 *             .vcenterName("ContosoVCenter")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:InventoryItem testItem /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/vcenters/{vcenterName}/inventoryItems/{inventoryItemName}
 * ```
 * @property inventoryItemName Name of the inventoryItem.
 * @property inventoryType They inventory type.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property managedResourceId Gets or sets the tracked resource id corresponding to the inventory resource.
 * @property moName Gets or sets the vCenter Managed Object name for the inventory item.
 * @property moRefId Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
 * @property resourceGroupName The Resource Group Name.
 * @property vcenterName Name of the vCenter.
 */
public data class InventoryItemArgs(
    public val inventoryItemName: Output<String>? = null,
    public val inventoryType: Output<Either<String, InventoryType>>? = null,
    public val kind: Output<String>? = null,
    public val managedResourceId: Output<String>? = null,
    public val moName: Output<String>? = null,
    public val moRefId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vcenterName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.InventoryItemArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.InventoryItemArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.InventoryItemArgs.builder()
            .inventoryItemName(inventoryItemName?.applyValue({ args0 -> args0 }))
            .inventoryType(
                inventoryType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .managedResourceId(managedResourceId?.applyValue({ args0 -> args0 }))
            .moName(moName?.applyValue({ args0 -> args0 }))
            .moRefId(moRefId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vcenterName(vcenterName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryItemArgs].
 */
@PulumiTagMarker
public class InventoryItemArgsBuilder internal constructor() {
    private var inventoryItemName: Output<String>? = null

    private var inventoryType: Output<Either<String, InventoryType>>? = null

    private var kind: Output<String>? = null

    private var managedResourceId: Output<String>? = null

    private var moName: Output<String>? = null

    private var moRefId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vcenterName: Output<String>? = null

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("lwmgerctkoxhjhsh")
    public suspend fun inventoryItemName(`value`: Output<String>) {
        this.inventoryItemName = value
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("mnpwhwkvxxqbavcx")
    public suspend fun inventoryType(`value`: Output<Either<String, InventoryType>>) {
        this.inventoryType = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("aexrqbkjctjpqweh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Gets or sets the tracked resource id corresponding to the inventory resource.
     */
    @JvmName("brgvluiviqmkcvdp")
    public suspend fun managedResourceId(`value`: Output<String>) {
        this.managedResourceId = value
    }

    /**
     * @param value Gets or sets the vCenter Managed Object name for the inventory item.
     */
    @JvmName("alixashdirkedbhv")
    public suspend fun moName(`value`: Output<String>) {
        this.moName = value
    }

    /**
     * @param value Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
     */
    @JvmName("vqywjsgrtgshicro")
    public suspend fun moRefId(`value`: Output<String>) {
        this.moRefId = value
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("etcqjjhdctdwpulk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("sfhbpkemlctobtjx")
    public suspend fun vcenterName(`value`: Output<String>) {
        this.vcenterName = value
    }

    /**
     * @param value Name of the inventoryItem.
     */
    @JvmName("vhmudemjesbmluiw")
    public suspend fun inventoryItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemName = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("myelwnciifiquxjc")
    public suspend fun inventoryType(`value`: Either<String, InventoryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("jbttgkwdetnygguk")
    public fun inventoryType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InventoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value They inventory type.
     */
    @JvmName("olvchtbnqflbmesp")
    public fun inventoryType(`value`: InventoryType) {
        val toBeMapped = Either.ofRight<String, InventoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inventoryType = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("vtdmfhhoosskgspi")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Gets or sets the tracked resource id corresponding to the inventory resource.
     */
    @JvmName("urdghcusdmgierdv")
    public suspend fun managedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceId = mapped
    }

    /**
     * @param value Gets or sets the vCenter Managed Object name for the inventory item.
     */
    @JvmName("mpqiqhfvywjjjgwv")
    public suspend fun moName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moName = mapped
    }

    /**
     * @param value Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
     */
    @JvmName("apkrhboyexjgwglv")
    public suspend fun moRefId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.moRefId = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("ijuoqnuvgcgevrmn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vCenter.
     */
    @JvmName("jvijcnvmktrgbeqk")
    public suspend fun vcenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcenterName = mapped
    }

    internal fun build(): InventoryItemArgs = InventoryItemArgs(
        inventoryItemName = inventoryItemName,
        inventoryType = inventoryType,
        kind = kind,
        managedResourceId = managedResourceId,
        moName = moName,
        moRefId = moRefId,
        resourceGroupName = resourceGroupName,
        vcenterName = vcenterName,
    )
}
