@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GuestAgentProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin as guestAgentProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileResponse.Companion.toKotlin as osProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse.Companion.toKotlin as placementProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin as resourceStatusResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin as securityProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * Define the virtualMachine.
 * Azure REST API version: 2022-07-15-preview. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.ConnectedVMwarevSphere.VirtualMachine("virtualMachine", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.HardwareProfileArgs
 *         {
 *             MemorySizeMB = 4196,
 *             NumCPUs = 4,
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         ResourcePoolId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool",
 *         TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate",
 *         VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         VirtualMachineName = "DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualMachine(ctx, "virtualMachine", &connectedvmwarevsphere.VirtualMachineArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &connectedvmwarevsphere.HardwareProfileArgs{
 * 				MemorySizeMB: pulumi.Int(4196),
 * 				NumCPUs:      pulumi.Int(4),
 * 			},
 * 			Location:           pulumi.String("East US"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ResourcePoolId:     pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool"),
 * 			TemplateId:         pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate"),
 * 			VCenterId:          pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			VirtualMachineName: pulumi.String("DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .memorySizeMB(4196)
 *                 .numCPUs(4)
 *                 .build())
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .resourcePoolId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool")
 *             .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate")
 *             .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *             .virtualMachineName("DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualMachine DemoVM /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachines/{virtualMachineName}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * Gets the name of the corresponding resource in Kubernetes.
     */
    public val customResourceName: Output<String>
        get() = javaResource.customResourceName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Firmware type
     */
    public val firmwareType: Output<String>?
        get() = javaResource.firmwareType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the folder path of the vm.
     */
    public val folderPath: Output<String>
        get() = javaResource.folderPath().applyValue({ args0 -> args0 })

    /**
     * Guest agent status properties.
     */
    public val guestAgentProfile: Output<GuestAgentProfileResponse>?
        get() = javaResource.guestAgentProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> guestAgentProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Hardware properties.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the instance uuid of the vm.
     */
    public val instanceUuid: Output<String>
        get() = javaResource.instanceUuid().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the inventory Item ID for the virtual machine.
     */
    public val inventoryItemId: Output<String>?
        get() = javaResource.inventoryItemId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter Managed Object name for the virtual machine.
     */
    public val moName: Output<String>
        get() = javaResource.moName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
     */
    public val moRefId: Output<String>?
        get() = javaResource.moRefId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network properties.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * OS properties.
     */
    public val osProfile: Output<OsProfileResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    osProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Placement properties.
     */
    public val placementProfile: Output<PlacementProfileResponse>?
        get() = javaResource.placementProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> placementProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the power state of the virtual machine.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will
     * deploy.
     */
    public val resourcePoolId: Output<String>?
        get() = javaResource.resourcePoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the security profile.
     */
    public val securityProfile: Output<SecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets the SMBIOS UUID of the vm.
     */
    public val smbiosUuid: Output<String>?
        get() = javaResource.smbiosUuid().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource status information.
     */
    public val statuses: Output<List<ResourceStatusResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * Storage properties.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system data.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the ARM Id of the template resource to deploy the virtual machine.
     */
    public val templateId: Output<String>?
        get() = javaResource.templateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for this resource.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    public val vCenterId: Output<String>?
        get() = javaResource.vCenterId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets a unique identifier for the vm resource.
     */
    public val vmId: Output<String>
        get() = javaResource.vmId().applyValue({ args0 -> args0 })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
