@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.InfrastructureProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileForVMInstanceResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin as hardwareProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.InfrastructureProfileResponse.Companion.toKotlin as infrastructureProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileForVMInstanceResponse.Companion.toKotlin as osProfileForVMInstanceResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse.Companion.toKotlin as placementProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin as resourceStatusResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin as securityProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse.Companion.toKotlin as storageProfileResponseToKotlin
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VirtualMachineInstance].
 */
@PulumiTagMarker
public class VirtualMachineInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineInstanceArgs = VirtualMachineInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineInstanceArgsBuilder.() -> Unit) {
        val builder = VirtualMachineInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VirtualMachineInstance {
        val builtJavaResource =
            com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineInstance(builtJavaResource)
    }
}

/**
 * Define the virtualMachineInstance.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-10-01.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.ConnectedVMwarevSphere.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.HardwareProfileArgs
 *         {
 *             MemorySizeMB = 4196,
 *             NumCPUs = 4,
 *         },
 *         InfrastructureProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.InfrastructureProfileArgs
 *         {
 *             TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate",
 *             VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         },
 *         PlacementProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.PlacementProfileArgs
 *         {
 *             ResourcePoolId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &connectedvmwarevsphere.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &connectedvmwarevsphere.HardwareProfileArgs{
 * 				MemorySizeMB: pulumi.Int(4196),
 * 				NumCPUs:      pulumi.Int(4),
 * 			},
 * 			InfrastructureProfile: &connectedvmwarevsphere.InfrastructureProfileArgs{
 * 				TemplateId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate"),
 * 				VCenterId:  pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			},
 * 			PlacementProfile: &connectedvmwarevsphere.PlacementProfileArgs{
 * 				ResourcePoolId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .memorySizeMB(4196)
 *                 .numCPUs(4)
 *                 .build())
 *             .infrastructureProfile(InfrastructureProfileArgs.builder()
 *                 .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate")
 *                 .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *                 .build())
 *             .placementProfile(PlacementProfileArgs.builder()
 *                 .resourcePoolId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool")
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualMachineInstance default /{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default
 * ```
 */
public class VirtualMachineInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance,
) : KotlinCustomResource(javaResource, VirtualMachineInstanceMapper) {
    /**
     * Gets or sets the extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Hardware properties.
     */
    public val hardwareProfile: Output<HardwareProfileResponse>?
        get() = javaResource.hardwareProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hardwareProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the infrastructure profile.
     */
    public val infrastructureProfile: Output<InfrastructureProfileResponse>?
        get() = javaResource.infrastructureProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> infrastructureProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network properties.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * OS properties.
     */
    public val osProfile: Output<OsProfileForVMInstanceResponse>?
        get() = javaResource.osProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    osProfileForVMInstanceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Placement properties.
     */
    public val placementProfile: Output<PlacementProfileResponse>?
        get() = javaResource.placementProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> placementProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the power state of the virtual machine.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets a unique identifier for the vm resource.
     */
    public val resourceUid: Output<String>
        get() = javaResource.resourceUid().applyValue({ args0 -> args0 })

    /**
     * Gets the security profile.
     */
    public val securityProfile: Output<SecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The resource status information.
     */
    public val statuses: Output<List<ResourceStatusResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceStatusResponseToKotlin(args0)
                })
            })
        })

    /**
     * Storage properties.
     */
    public val storageProfile: Output<StorageProfileResponse>?
        get() = javaResource.storageProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VirtualMachineInstanceMapper : ResourceMapper<VirtualMachineInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineInstance =
        VirtualMachineInstance(
            javaResource as
                com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance,
        )
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineInstance].
 */
public suspend fun virtualMachineInstance(
    name: String,
    block: suspend VirtualMachineInstanceResourceBuilder.() -> Unit,
): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineInstance(name: String): VirtualMachineInstance {
    val builder = VirtualMachineInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
