@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin

import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.InfrastructureProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.InfrastructureProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.OsProfileForVMInstanceArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.OsProfileForVMInstanceArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.PlacementProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.PlacementProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.SecurityProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.SecurityProfileArgsBuilder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Define the virtualMachineInstance.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-10-01.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.ConnectedVMwarevSphere.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.ConnectedVMwarevSphere.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.HardwareProfileArgs
 *         {
 *             MemorySizeMB = 4196,
 *             NumCPUs = 4,
 *         },
 *         InfrastructureProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.InfrastructureProfileArgs
 *         {
 *             TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate",
 *             VCenterId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter",
 *         },
 *         PlacementProfile = new AzureNative.ConnectedVMwarevSphere.Inputs.PlacementProfileArgs
 *         {
 *             ResourcePoolId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/connectedvmwarevsphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connectedvmwarevsphere.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &connectedvmwarevsphere.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &connectedvmwarevsphere.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &connectedvmwarevsphere.HardwareProfileArgs{
 * 				MemorySizeMB: pulumi.Int(4196),
 * 				NumCPUs:      pulumi.Int(4),
 * 			},
 * 			InfrastructureProfile: &connectedvmwarevsphere.InfrastructureProfileArgs{
 * 				TemplateId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate"),
 * 				VCenterId:  pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter"),
 * 			},
 * 			PlacementProfile: &connectedvmwarevsphere.PlacementProfileArgs{
 * 				ResourcePoolId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstance;
 * import com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.HardwareProfileArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs;
 * import com.pulumi.azurenative.connectedvmwarevsphere.inputs.PlacementProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso")
 *                 .type("customLocation")
 *                 .build())
 *             .hardwareProfile(HardwareProfileArgs.builder()
 *                 .memorySizeMB(4196)
 *                 .numCPUs(4)
 *                 .build())
 *             .infrastructureProfile(InfrastructureProfileArgs.builder()
 *                 .templateId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VirtualMachineTemplates/WebFrontEndTemplate")
 *                 .vCenterId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/VCenters/ContosoVCenter")
 *                 .build())
 *             .placementProfile(PlacementProfileArgs.builder()
 *                 .resourcePoolId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.ConnectedVMwarevSphere/ResourcePools/HRPool")
 *                 .build())
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:connectedvmwarevsphere:VirtualMachineInstance default /{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default
 * ```
 * @property extendedLocation Gets or sets the extended location.
 * @property hardwareProfile Hardware properties.
 * @property infrastructureProfile Gets the infrastructure profile.
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property placementProfile Placement properties.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 * @property securityProfile Gets the security profile.
 * @property storageProfile Storage properties.
 */
public data class VirtualMachineInstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val infrastructureProfile: Output<InfrastructureProfileArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OsProfileForVMInstanceArgs>? = null,
    public val placementProfile: Output<PlacementProfileArgs>? = null,
    public val resourceUri: Output<String>? = null,
    public val securityProfile: Output<SecurityProfileArgs>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.VirtualMachineInstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .infrastructureProfile(
                infrastructureProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .placementProfile(placementProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(
                storageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstanceArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var infrastructureProfile: Output<InfrastructureProfileArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OsProfileForVMInstanceArgs>? = null

    private var placementProfile: Output<PlacementProfileArgs>? = null

    private var resourceUri: Output<String>? = null

    private var securityProfile: Output<SecurityProfileArgs>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("qhujusxwsivlchls")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("bwsaftnxrtlsfqdo")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Gets the infrastructure profile.
     */
    @JvmName("ojeulaiugwtgyoxi")
    public suspend fun infrastructureProfile(`value`: Output<InfrastructureProfileArgs>) {
        this.infrastructureProfile = value
    }

    /**
     * @param value Network properties.
     */
    @JvmName("sbcyrmnnvutmonck")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OS properties.
     */
    @JvmName("gxkhlwtghqrxcfbk")
    public suspend fun osProfile(`value`: Output<OsProfileForVMInstanceArgs>) {
        this.osProfile = value
    }

    /**
     * @param value Placement properties.
     */
    @JvmName("ulwadljscepgstif")
    public suspend fun placementProfile(`value`: Output<PlacementProfileArgs>) {
        this.placementProfile = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("haqdjaqcyuoychgg")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value Gets the security profile.
     */
    @JvmName("tuuktsoifwijohhs")
    public suspend fun securityProfile(`value`: Output<SecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("vyjvwlrrqtesibxx")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("tevhkdyaowdwbowi")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("nbxnwyinpfqgksis")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("yflcpqlyhrqigmwa")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Hardware properties.
     */
    @JvmName("rbxsmqvaxxnrlqlq")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Gets the infrastructure profile.
     */
    @JvmName("mntvfthtenavloqp")
    public suspend fun infrastructureProfile(`value`: InfrastructureProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureProfile = mapped
    }

    /**
     * @param argument Gets the infrastructure profile.
     */
    @JvmName("jcfcuyuwhlgbnueh")
    public suspend
    fun infrastructureProfile(argument: suspend InfrastructureProfileArgsBuilder.() -> Unit) {
        val toBeMapped = InfrastructureProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.infrastructureProfile = mapped
    }

    /**
     * @param value Network properties.
     */
    @JvmName("resymafvhtskhepe")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network properties.
     */
    @JvmName("qmmayafecnwhvaww")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OS properties.
     */
    @JvmName("uipnwxjeeknqnhsd")
    public suspend fun osProfile(`value`: OsProfileForVMInstanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OS properties.
     */
    @JvmName("gbbdraxeldoissgc")
    public suspend fun osProfile(argument: suspend OsProfileForVMInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileForVMInstanceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value Placement properties.
     */
    @JvmName("fosaycifunmykusc")
    public suspend fun placementProfile(`value`: PlacementProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementProfile = mapped
    }

    /**
     * @param argument Placement properties.
     */
    @JvmName("smasbpscejyslnqe")
    public suspend fun placementProfile(argument: suspend PlacementProfileArgsBuilder.() -> Unit) {
        val toBeMapped = PlacementProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.placementProfile = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("ajdmlfksmrtgjxcb")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value Gets the security profile.
     */
    @JvmName("xbqimkevakxwnspk")
    public suspend fun securityProfile(`value`: SecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Gets the security profile.
     */
    @JvmName("rjhfgetbslskvjvn")
    public suspend fun securityProfile(argument: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("ntvkpmpluwnpmxlx")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage properties.
     */
    @JvmName("wfflscqsjwgdycsr")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    internal fun build(): VirtualMachineInstanceArgs = VirtualMachineInstanceArgs(
        extendedLocation = extendedLocation,
        hardwareProfile = hardwareProfile,
        infrastructureProfile = infrastructureProfile,
        networkProfile = networkProfile,
        osProfile = osProfile,
        placementProfile = placementProfile,
        resourceUri = resourceUri,
        securityProfile = securityProfile,
        storageProfile = storageProfile,
    )
}
