@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs.builder
import com.pulumi.azurenative.connectedvmwarevsphere.kotlin.enums.FirmwareType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the vCenter infrastructure specific settings for the virtual machine.
 * @property firmwareType Firmware type
 * @property inventoryItemId Gets or sets the inventory Item ID for the virtual machine.
 * @property smbiosUuid Gets or sets the SMBIOS UUID of the vm.
 * @property templateId Gets or sets the ARM Id of the template resource to deploy the virtual machine.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
 */
public data class InfrastructureProfileArgs(
    public val firmwareType: Output<Either<String, FirmwareType>>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val smbiosUuid: Output<String>? = null,
    public val templateId: Output<String>? = null,
    public val vCenterId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.InfrastructureProfileArgs.builder()
            .firmwareType(
                firmwareType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .smbiosUuid(smbiosUuid?.applyValue({ args0 -> args0 }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .vCenterId(vCenterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureProfileArgs].
 */
@PulumiTagMarker
public class InfrastructureProfileArgsBuilder internal constructor() {
    private var firmwareType: Output<Either<String, FirmwareType>>? = null

    private var inventoryItemId: Output<String>? = null

    private var smbiosUuid: Output<String>? = null

    private var templateId: Output<String>? = null

    private var vCenterId: Output<String>? = null

    /**
     * @param value Firmware type
     */
    @JvmName("sfsrdcgpxftuwjhu")
    public suspend fun firmwareType(`value`: Output<Either<String, FirmwareType>>) {
        this.firmwareType = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the virtual machine.
     */
    @JvmName("ccfnwmyvadwfciyr")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Gets or sets the SMBIOS UUID of the vm.
     */
    @JvmName("tsjggguolnlqnyfh")
    public suspend fun smbiosUuid(`value`: Output<String>) {
        this.smbiosUuid = value
    }

    /**
     * @param value Gets or sets the ARM Id of the template resource to deploy the virtual machine.
     */
    @JvmName("qtmfdnuebqprqjnw")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("aduvbjhdxgbyxjge")
    public suspend fun vCenterId(`value`: Output<String>) {
        this.vCenterId = value
    }

    /**
     * @param value Firmware type
     */
    @JvmName("tlmllewxjejfcpvr")
    public suspend fun firmwareType(`value`: Either<String, FirmwareType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Firmware type
     */
    @JvmName("vtxodwutomcrlqxi")
    public fun firmwareType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirmwareType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Firmware type
     */
    @JvmName("otfgudabfwldoeky")
    public fun firmwareType(`value`: FirmwareType) {
        val toBeMapped = Either.ofRight<String, FirmwareType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firmwareType = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the virtual machine.
     */
    @JvmName("ialpauqtoqhuxwqq")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Gets or sets the SMBIOS UUID of the vm.
     */
    @JvmName("tyluvprvjmcgqpth")
    public suspend fun smbiosUuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbiosUuid = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the template resource to deploy the virtual machine.
     */
    @JvmName("lyjolekujgaxdrcg")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
     */
    @JvmName("ujntpiydjonlgwar")
    public suspend fun vCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCenterId = mapped
    }

    internal fun build(): InfrastructureProfileArgs = InfrastructureProfileArgs(
        firmwareType = firmwareType,
        inventoryItemId = inventoryItemId,
        smbiosUuid = smbiosUuid,
        templateId = templateId,
        vCenterId = vCenterId,
    )
}
