@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.inputs

import com.pulumi.azurenative.connectedvmwarevsphere.inputs.VICredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Username / Password Credentials to connect to vcenter.
 * @property password Gets or sets the password to connect with the vCenter.
 * @property username Gets or sets username to connect with the vCenter.
 */
public data class VICredentialArgs(
    public val password: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.connectedvmwarevsphere.inputs.VICredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.connectedvmwarevsphere.inputs.VICredentialArgs =
        com.pulumi.azurenative.connectedvmwarevsphere.inputs.VICredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VICredentialArgs].
 */
@PulumiTagMarker
public class VICredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Gets or sets the password to connect with the vCenter.
     */
    @JvmName("hudqfytteekxgkuu")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Gets or sets username to connect with the vCenter.
     */
    @JvmName("gcxqmxtmhyfpqpet")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Gets or sets the password to connect with the vCenter.
     */
    @JvmName("cidkfxhbmlyggevx")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Gets or sets username to connect with the vCenter.
     */
    @JvmName("bffkdrrxqsnaittb")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): VICredentialArgs = VICredentialArgs(
        password = password,
        username = username,
    )
}
