@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the virtualMachine.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property extendedLocation Gets or sets the extended location.
 * @property firmwareType Firmware type
 * @property folderPath Gets or sets the folder path of the vm.
 * @property guestAgentProfile Guest agent status properties.
 * @property hardwareProfile Hardware properties.
 * @property id Gets or sets the Id.
 * @property identity The identity of the resource.
 * @property instanceUuid Gets or sets the instance uuid of the vm.
 * @property inventoryItemId Gets or sets the inventory Item ID for the virtual machine.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property moName Gets or sets the vCenter Managed Object name for the virtual machine.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
 * @property name Gets or sets the name.
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property placementProfile Placement properties.
 * @property powerState Gets the power state of the virtual machine.
 * @property provisioningState Gets or sets the provisioning state.
 * @property resourcePoolId Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will
 * deploy.
 * @property securityProfile Gets the security profile.
 * @property smbiosUuid Gets or sets the SMBIOS UUID of the vm.
 * @property statuses The resource status information.
 * @property storageProfile Storage properties.
 * @property systemData The system data.
 * @property tags Gets or sets the Resource tags.
 * @property templateId Gets or sets the ARM Id of the template resource to deploy the virtual machine.
 * @property type Gets or sets the type of the resource.
 * @property uuid Gets or sets a unique identifier for this resource.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
 * @property vmId Gets or sets a unique identifier for the vm resource.
 */
public data class GetVirtualMachineResult(
    public val customResourceName: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val firmwareType: String? = null,
    public val folderPath: String,
    public val guestAgentProfile: GuestAgentProfileResponse? = null,
    public val hardwareProfile: HardwareProfileResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val instanceUuid: String,
    public val inventoryItemId: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val moName: String,
    public val moRefId: String? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OsProfileResponse? = null,
    public val placementProfile: PlacementProfileResponse? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val resourcePoolId: String? = null,
    public val securityProfile: SecurityProfileResponse? = null,
    public val smbiosUuid: String? = null,
    public val statuses: List<ResourceStatusResponse>,
    public val storageProfile: StorageProfileResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val templateId: String? = null,
    public val type: String,
    public val uuid: String,
    public val vCenterId: String? = null,
    public val vmId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetVirtualMachineResult):
            GetVirtualMachineResult = GetVirtualMachineResult(
            customResourceName = javaType.customResourceName(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firmwareType = javaType.firmwareType().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath(),
            guestAgentProfile = javaType.guestAgentProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.GuestAgentProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hardwareProfile = javaType.hardwareProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.HardwareProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceUuid = javaType.instanceUuid(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            moName = javaType.moName(),
            moRefId = javaType.moRefId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.OsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            placementProfile = javaType.placementProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.PlacementProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            resourcePoolId = javaType.resourcePoolId().map({ args0 -> args0 }).orElse(null),
            securityProfile = javaType.securityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SecurityProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            smbiosUuid = javaType.smbiosUuid().map({ args0 -> args0 }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            storageProfile = javaType.storageProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uuid = javaType.uuid(),
            vCenterId = javaType.vCenterId().map({ args0 -> args0 }).orElse(null),
            vmId = javaType.vmId(),
        )
    }
}
