@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Define the virtualMachineTemplate.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property disks Gets or sets the disks the template.
 * @property extendedLocation Gets or sets the extended location.
 * @property firmwareType Firmware type
 * @property folderPath Gets or sets the folder path of the template.
 * @property id Gets or sets the Id.
 * @property inventoryItemId Gets or sets the inventory Item ID for the virtual machine template.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location Gets or sets the location.
 * @property memorySizeMB Gets or sets memory size in MBs for the template.
 * @property moName Gets or sets the vCenter Managed Object name for the virtual machine template.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine
 * template.
 * @property name Gets or sets the name.
 * @property networkInterfaces Gets or sets the network interfaces of the template.
 * @property numCPUs Gets or sets the number of vCPUs for the template.
 * @property numCoresPerSocket Gets or sets the number of cores per socket for the template.
 * Defaults to 1 if unspecified.
 * @property osName Gets or sets os name.
 * @property osType Gets or sets the type of the os.
 * @property provisioningState Gets or sets the provisioning state.
 * @property statuses The resource status information.
 * @property systemData The system data.
 * @property tags Gets or sets the Resource tags.
 * @property toolsVersion Gets or sets the current version of VMware Tools.
 * @property toolsVersionStatus Gets or sets the current version status of VMware Tools installed in the guest operating system.
 * @property type Gets or sets the type of the resource.
 * @property uuid Gets or sets a unique identifier for this resource.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this template resides.
 */
public data class GetVirtualMachineTemplateResult(
    public val customResourceName: String,
    public val disks: List<VirtualDiskResponse>,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val firmwareType: String,
    public val folderPath: String,
    public val id: String,
    public val inventoryItemId: String? = null,
    public val kind: String? = null,
    public val location: String,
    public val memorySizeMB: Int,
    public val moName: String,
    public val moRefId: String? = null,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfaceResponse>,
    public val numCPUs: Int,
    public val numCoresPerSocket: Int,
    public val osName: String,
    public val osType: String,
    public val provisioningState: String,
    public val statuses: List<ResourceStatusResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val toolsVersion: String,
    public val toolsVersionStatus: String,
    public val type: String,
    public val uuid: String,
    public val vCenterId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.GetVirtualMachineTemplateResult):
            GetVirtualMachineTemplateResult = GetVirtualMachineTemplateResult(
            customResourceName = javaType.customResourceName(),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.VirtualDiskResponse.Companion.toKotlin(args0)
                })
            }),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firmwareType = javaType.firmwareType(),
            folderPath = javaType.folderPath(),
            id = javaType.id(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            memorySizeMB = javaType.memorySizeMB(),
            moName = javaType.moName(),
            moRefId = javaType.moRefId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            numCPUs = javaType.numCPUs(),
            numCoresPerSocket = javaType.numCoresPerSocket(),
            osName = javaType.osName(),
            osType = javaType.osType(),
            provisioningState = javaType.provisioningState(),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.ResourceStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            toolsVersion = javaType.toolsVersion(),
            toolsVersionStatus = javaType.toolsVersionStatus(),
            type = javaType.type(),
            uuid = javaType.uuid(),
            vCenterId = javaType.vCenterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
