@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the vCenter infrastructure specific settings for the virtual machine.
 * @property customResourceName Gets the name of the corresponding resource in Kubernetes.
 * @property firmwareType Firmware type
 * @property folderPath Gets or sets the folder path of the vm.
 * @property instanceUuid Gets or sets the instance uuid of the vm.
 * @property inventoryItemId Gets or sets the inventory Item ID for the virtual machine.
 * @property moName Gets or sets the vCenter Managed Object name for the virtual machine.
 * @property moRefId Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
 * @property smbiosUuid Gets or sets the SMBIOS UUID of the vm.
 * @property templateId Gets or sets the ARM Id of the template resource to deploy the virtual machine.
 * @property vCenterId Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
 */
public data class InfrastructureProfileResponse(
    public val customResourceName: String,
    public val firmwareType: String? = null,
    public val folderPath: String,
    public val instanceUuid: String,
    public val inventoryItemId: String? = null,
    public val moName: String,
    public val moRefId: String,
    public val smbiosUuid: String? = null,
    public val templateId: String? = null,
    public val vCenterId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.InfrastructureProfileResponse):
            InfrastructureProfileResponse = InfrastructureProfileResponse(
            customResourceName = javaType.customResourceName(),
            firmwareType = javaType.firmwareType().map({ args0 -> args0 }).orElse(null),
            folderPath = javaType.folderPath(),
            instanceUuid = javaType.instanceUuid(),
            inventoryItemId = javaType.inventoryItemId().map({ args0 -> args0 }).orElse(null),
            moName = javaType.moName(),
            moRefId = javaType.moRefId(),
            smbiosUuid = javaType.smbiosUuid().map({ args0 -> args0 }).orElse(null),
            templateId = javaType.templateId().map({ args0 -> args0 }).orElse(null),
            vCenterId = javaType.vCenterId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
