@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource status information.
 * @property lastUpdatedAt The last update time for this condition.
 * @property message A human readable message indicating details about the status.
 * @property reason The reason for the condition's status.
 * @property severity Severity with which to treat failures of this type of condition.
 * @property status Status of the condition.
 * @property type The type of the condition.
 */
public data class ResourceStatusResponse(
    public val lastUpdatedAt: String,
    public val message: String,
    public val reason: String,
    public val severity: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.ResourceStatusResponse):
            ResourceStatusResponse = ResourceStatusResponse(
            lastUpdatedAt = javaType.lastUpdatedAt(),
            message = javaType.message(),
            reason = javaType.reason(),
            severity = javaType.severity(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
