@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin

import com.pulumi.azurenative.consumption.kotlin.outputs.BudgetFilterResponse
import com.pulumi.azurenative.consumption.kotlin.outputs.BudgetTimePeriodResponse
import com.pulumi.azurenative.consumption.kotlin.outputs.CurrentSpendResponse
import com.pulumi.azurenative.consumption.kotlin.outputs.ForecastSpendResponse
import com.pulumi.azurenative.consumption.kotlin.outputs.NotificationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.consumption.kotlin.outputs.BudgetFilterResponse.Companion.toKotlin as budgetFilterResponseToKotlin
import com.pulumi.azurenative.consumption.kotlin.outputs.BudgetTimePeriodResponse.Companion.toKotlin as budgetTimePeriodResponseToKotlin
import com.pulumi.azurenative.consumption.kotlin.outputs.CurrentSpendResponse.Companion.toKotlin as currentSpendResponseToKotlin
import com.pulumi.azurenative.consumption.kotlin.outputs.ForecastSpendResponse.Companion.toKotlin as forecastSpendResponseToKotlin
import com.pulumi.azurenative.consumption.kotlin.outputs.NotificationResponse.Companion.toKotlin as notificationResponseToKotlin

/**
 * Builder for [Budget].
 */
@PulumiTagMarker
public class BudgetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetArgs = BudgetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetArgsBuilder.() -> Unit) {
        val builder = BudgetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Budget {
        val builtJavaResource = com.pulumi.azurenative.consumption.Budget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Budget(builtJavaResource)
    }
}

/**
 * A budget resource.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2017-12-30-preview, 2018-10-01, 2019-05-01, 2019-06-01, 2023-11-01.
 * ## Example Usage
 * ### CreateOrUpdateBudget
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var budget = new AzureNative.Consumption.Budget("budget", new()
 *     {
 *         Amount = 100.65,
 *         BudgetName = "TestBudget",
 *         Category = AzureNative.Consumption.CategoryType.Cost,
 *         ETag = "\"1d34d016a593709\"",
 *         Filter = new AzureNative.Consumption.Inputs.BudgetFilterArgs
 *         {
 *             And = new[]
 *             {
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Dimensions = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "ResourceId",
 *                         Operator = AzureNative.Consumption.BudgetOperatorType.In,
 *                         Values = new[]
 *                         {
 *                             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2",
 *                             "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Tags = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "category",
 *                         Operator = AzureNative.Consumption.BudgetOperatorType.In,
 *                         Values = new[]
 *                         {
 *                             "Dev",
 *                             "Prod",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Consumption.Inputs.BudgetFilterPropertiesArgs
 *                 {
 *                     Tags = new AzureNative.Consumption.Inputs.BudgetComparisonExpressionArgs
 *                     {
 *                         Name = "department",
 *                         Operator = AzureNative.Consumption.BudgetOperatorType.In,
 *                         Values = new[]
 *                         {
 *                             "engineering",
 *                             "sales",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Notifications =
 *         {
 *             { "Actual_GreaterThan_80_Percent", new AzureNative.Consumption.Inputs.NotificationArgs
 *             {
 *                 ContactEmails = new[]
 *                 {
 *                     "johndoe@contoso.com",
 *                     "janesmith@contoso.com",
 *                 },
 *                 ContactGroups = new[]
 *                 {
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup",
 *                 },
 *                 ContactRoles = new[]
 *                 {
 *                     "Contributor",
 *                     "Reader",
 *                 },
 *                 Enabled = true,
 *                 Locale = AzureNative.Consumption.CultureCode.En_us,
 *                 Operator = AzureNative.Consumption.OperatorType.GreaterThan,
 *                 Threshold = 80,
 *                 ThresholdType = AzureNative.Consumption.ThresholdType.Actual,
 *             } },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         TimeGrain = AzureNative.Consumption.TimeGrainType.Monthly,
 *         TimePeriod = new AzureNative.Consumption.Inputs.BudgetTimePeriodArgs
 *         {
 *             EndDate = "2018-10-31T00:00:00Z",
 *             StartDate = "2017-10-01T00:00:00Z",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/consumption/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := consumption.NewBudget(ctx, "budget", &consumption.BudgetArgs{
 * 			Amount:     pulumi.Float64(100.65),
 * 			BudgetName: pulumi.String("TestBudget"),
 * 			Category:   pulumi.String(consumption.CategoryTypeCost),
 * 			ETag:       pulumi.String("\"1d34d016a593709\""),
 * 			Filter: &consumption.BudgetFilterArgs{
 * 				And: consumption.BudgetFilterPropertiesArray{
 * 					&consumption.BudgetFilterPropertiesArgs{
 * 						Dimensions: &consumption.BudgetComparisonExpressionArgs{
 * 							Name:     pulumi.String("ResourceId"),
 * 							Operator: pulumi.String(consumption.BudgetOperatorTypeIn),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2"),
 * 								pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1"),
 * 							},
 * 						},
 * 					},
 * 					&consumption.BudgetFilterPropertiesArgs{
 * 						Tags: &consumption.BudgetComparisonExpressionArgs{
 * 							Name:     pulumi.String("category"),
 * 							Operator: pulumi.String(consumption.BudgetOperatorTypeIn),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("Dev"),
 * 								pulumi.String("Prod"),
 * 							},
 * 						},
 * 					},
 * 					&consumption.BudgetFilterPropertiesArgs{
 * 						Tags: &consumption.BudgetComparisonExpressionArgs{
 * 							Name:     pulumi.String("department"),
 * 							Operator: pulumi.String(consumption.BudgetOperatorTypeIn),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("engineering"),
 * 								pulumi.String("sales"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Notifications: consumption.NotificationMap{
 * 				"Actual_GreaterThan_80_Percent": &consumption.NotificationArgs{
 * 					ContactEmails: pulumi.StringArray{
 * 						pulumi.String("johndoe@contoso.com"),
 * 						pulumi.String("janesmith@contoso.com"),
 * 					},
 * 					ContactGroups: pulumi.StringArray{
 * 						pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup"),
 * 					},
 * 					ContactRoles: pulumi.StringArray{
 * 						pulumi.String("Contributor"),
 * 						pulumi.String("Reader"),
 * 					},
 * 					Enabled:       pulumi.Bool(true),
 * 					Locale:        pulumi.String(consumption.CultureCode_En_Us),
 * 					Operator:      pulumi.String(consumption.OperatorTypeGreaterThan),
 * 					Threshold:     pulumi.Float64(80),
 * 					ThresholdType: pulumi.String(consumption.ThresholdTypeActual),
 * 				},
 * 			},
 * 			Scope:     pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			TimeGrain: pulumi.String(consumption.TimeGrainTypeMonthly),
 * 			TimePeriod: &consumption.BudgetTimePeriodArgs{
 * 				EndDate:   pulumi.String("2018-10-31T00:00:00Z"),
 * 				StartDate: pulumi.String("2017-10-01T00:00:00Z"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.consumption.Budget;
 * import com.pulumi.azurenative.consumption.BudgetArgs;
 * import com.pulumi.azurenative.consumption.inputs.BudgetFilterArgs;
 * import com.pulumi.azurenative.consumption.inputs.BudgetTimePeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var budget = new Budget("budget", BudgetArgs.builder()
 *             .amount(100.65)
 *             .budgetName("TestBudget")
 *             .category("Cost")
 *             .eTag("\"1d34d016a593709\"")
 *             .filter(BudgetFilterArgs.builder()
 *                 .and(
 *                     BudgetFilterPropertiesArgs.builder()
 *                         .dimensions(BudgetComparisonExpressionArgs.builder()
 *                             .name("ResourceId")
 *                             .operator("In")
 *                             .values(
 *                                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/MSVM2",
 *                                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/Microsoft.Compute/virtualMachines/platformcloudplatformGeneric1")
 *                             .build())
 *                         .build(),
 *                     BudgetFilterPropertiesArgs.builder()
 *                         .tags(BudgetComparisonExpressionArgs.builder()
 *                             .name("category")
 *                             .operator("In")
 *                             .values(
 *                                 "Dev",
 *                                 "Prod")
 *                             .build())
 *                         .build(),
 *                     BudgetFilterPropertiesArgs.builder()
 *                         .tags(BudgetComparisonExpressionArgs.builder()
 *                             .name("department")
 *                             .operator("In")
 *                             .values(
 *                                 "engineering",
 *                                 "sales")
 *                             .build())
 *                         .build())
 *                 .build())
 *             .notifications(Map.of("Actual_GreaterThan_80_Percent", Map.ofEntries(
 *                 Map.entry("contactEmails",
 *                     "johndoe@contoso.com",
 *                     "janesmith@contoso.com"),
 *                 Map.entry("contactGroups", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MYDEVTESTRG/providers/microsoft.insights/actionGroups/SampleActionGroup"),
 *                 Map.entry("contactRoles",
 *                     "Contributor",
 *                     "Reader"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("locale", "en-us"),
 *                 Map.entry("operator", "GreaterThan"),
 *                 Map.entry("threshold", 80),
 *                 Map.entry("thresholdType", "Actual")
 *             )))
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .timeGrain("Monthly")
 *             .timePeriod(BudgetTimePeriodArgs.builder()
 *                 .endDate("2018-10-31T00:00:00Z")
 *                 .startDate("2017-10-01T00:00:00Z")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:consumption:Budget TestBudget /{scope}/providers/Microsoft.Consumption/budgets/{budgetName}
 * ```
 */
public class Budget internal constructor(
    override val javaResource: com.pulumi.azurenative.consumption.Budget,
) : KotlinCustomResource(javaResource, BudgetMapper) {
    /**
     * The total amount of cost to track with the budget
     */
    public val amount: Output<Double>
        get() = javaResource.amount().applyValue({ args0 -> args0 })

    /**
     * The category of the budget, whether the budget tracks cost or usage.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The current amount of cost which is being tracked for a budget.
     */
    public val currentSpend: Output<CurrentSpendResponse>
        get() = javaResource.currentSpend().applyValue({ args0 ->
            args0.let({ args0 ->
                currentSpendResponseToKotlin(args0)
            })
        })

    /**
     * eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * May be used to filter budgets by user-specified dimensions and/or tags.
     */
    public val filter: Output<BudgetFilterResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    budgetFilterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The forecasted cost which is being tracked for a budget.
     */
    public val forecastSpend: Output<ForecastSpendResponse>
        get() = javaResource.forecastSpend().applyValue({ args0 ->
            args0.let({ args0 ->
                forecastSpendResponseToKotlin(args0)
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dictionary of notifications associated with the budget. Budget can have up to five notifications.
     */
    public val notifications: Output<Map<String, NotificationResponse>>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            notificationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
     */
    public val timeGrain: Output<String>
        get() = javaResource.timeGrain().applyValue({ args0 -> args0 })

    /**
     * Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
     */
    public val timePeriod: Output<BudgetTimePeriodResponse>
        get() = javaResource.timePeriod().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetTimePeriodResponseToKotlin(args0)
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BudgetMapper : ResourceMapper<Budget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.consumption.Budget::class == javaResource::class

    override fun map(javaResource: Resource): Budget = Budget(
        javaResource as
            com.pulumi.azurenative.consumption.Budget,
    )
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Budget].
 */
public suspend fun budget(name: String, block: suspend BudgetResourceBuilder.() -> Unit): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budget(name: String): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    return builder.build()
}
