@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The category of the budget, whether the budget tracks cost or usage.
 */
public enum class CategoryType(
    public val javaValue: com.pulumi.azurenative.consumption.enums.CategoryType,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.enums.CategoryType> {
    Cost(com.pulumi.azurenative.consumption.enums.CategoryType.Cost),
    ;

    override fun toJava(): com.pulumi.azurenative.consumption.enums.CategoryType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.enums.CategoryType):
            CategoryType = CategoryType.values().first { it.javaValue == javaType }
    }
}
