@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.inputs

import com.pulumi.azurenative.consumption.inputs.BudgetComparisonExpressionArgs.builder
import com.pulumi.azurenative.consumption.kotlin.enums.BudgetOperatorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The comparison expression to be used in the budgets.
 * @property name The name of the column to use in comparison.
 * @property operator The operator to use for comparison.
 * @property values Array of values to use for comparison
 */
public data class BudgetComparisonExpressionArgs(
    public val name: Output<String>,
    public val `operator`: Output<Either<String, BudgetOperatorType>>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.inputs.BudgetComparisonExpressionArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.inputs.BudgetComparisonExpressionArgs =
        com.pulumi.azurenative.consumption.inputs.BudgetComparisonExpressionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BudgetComparisonExpressionArgs].
 */
@PulumiTagMarker
public class BudgetComparisonExpressionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `operator`: Output<Either<String, BudgetOperatorType>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The name of the column to use in comparison.
     */
    @JvmName("qsghsqfogfhjvpme")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("fkbgblppqsbksdbq")
    public suspend fun `operator`(`value`: Output<Either<String, BudgetOperatorType>>) {
        this.`operator` = value
    }

    /**
     * @param value Array of values to use for comparison
     */
    @JvmName("rjsodyduglbrwvyt")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("pxxdjouoixcjtbfx")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Array of values to use for comparison
     */
    @JvmName("pchilpvwempbielt")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the column to use in comparison.
     */
    @JvmName("kwlnpdugoibtqfux")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("mkusfmuiywwxamox")
    public suspend fun `operator`(`value`: Either<String, BudgetOperatorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("thpwyirojwvbsguq")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BudgetOperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to use for comparison.
     */
    @JvmName("crcwmbwhheokghud")
    public fun `operator`(`value`: BudgetOperatorType) {
        val toBeMapped = Either.ofRight<String, BudgetOperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Array of values to use for comparison
     */
    @JvmName("qystrgysklupqjtv")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Array of values to use for comparison
     */
    @JvmName("cfngbjcmvfmuaqgq")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): BudgetComparisonExpressionArgs = BudgetComparisonExpressionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
