@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.inputs

import com.pulumi.azurenative.consumption.inputs.GetBudgetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property budgetName Budget Name.
 * @property scope The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
 */
public data class GetBudgetPlainArgs(
    public val budgetName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.inputs.GetBudgetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.inputs.GetBudgetPlainArgs =
        com.pulumi.azurenative.consumption.inputs.GetBudgetPlainArgs.builder()
            .budgetName(budgetName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBudgetPlainArgs].
 */
@PulumiTagMarker
public class GetBudgetPlainArgsBuilder internal constructor() {
    private var budgetName: String? = null

    private var scope: String? = null

    /**
     * @param value Budget Name.
     */
    @JvmName("gwgphvmvidlankqm")
    public suspend fun budgetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.budgetName = mapped
    }

    /**
     * @param value The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
     */
    @JvmName("frjkwfgjivyjckhh")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetBudgetPlainArgs = GetBudgetPlainArgs(
        budgetName = budgetName ?: throw PulumiNullFieldException("budgetName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
