@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A budget resource.
 * @property amount The total amount of cost to track with the budget
 * @property category The category of the budget, whether the budget tracks cost or usage.
 * @property currentSpend The current amount of cost which is being tracked for a budget.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property filter May be used to filter budgets by user-specified dimensions and/or tags.
 * @property forecastSpend The forecasted cost which is being tracked for a budget.
 * @property id Resource Id.
 * @property name Resource name.
 * @property notifications Dictionary of notifications associated with the budget. Budget can have up to five notifications.
 * @property timeGrain The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
 * @property timePeriod Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date.
 * @property type Resource type.
 */
public data class GetBudgetResult(
    public val amount: Double,
    public val category: String,
    public val currentSpend: CurrentSpendResponse,
    public val eTag: String? = null,
    public val filter: BudgetFilterResponse? = null,
    public val forecastSpend: ForecastSpendResponse,
    public val id: String,
    public val name: String,
    public val notifications: Map<String, NotificationResponse>? = null,
    public val timeGrain: String,
    public val timePeriod: BudgetTimePeriodResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.outputs.GetBudgetResult):
            GetBudgetResult = GetBudgetResult(
            amount = javaType.amount(),
            category = javaType.category(),
            currentSpend = javaType.currentSpend().let({ args0 ->
                com.pulumi.azurenative.consumption.kotlin.outputs.CurrentSpendResponse.Companion.toKotlin(args0)
            }),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.consumption.kotlin.outputs.BudgetFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forecastSpend = javaType.forecastSpend().let({ args0 ->
                com.pulumi.azurenative.consumption.kotlin.outputs.ForecastSpendResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            name = javaType.name(),
            notifications = javaType.notifications().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.consumption.kotlin.outputs.NotificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            timeGrain = javaType.timeGrain(),
            timePeriod = javaType.timePeriod().let({ args0 ->
                com.pulumi.azurenative.consumption.kotlin.outputs.BudgetTimePeriodResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
