@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin

import com.pulumi.azurenative.containerinstance.kotlin.outputs.ConfidentialComputePropertiesResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupDiagnosticsResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupIdentityResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupPropertiesResponseInstanceView
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupSubnetIdResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.DeploymentExtensionSpecResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.DnsConfigurationResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.EncryptionPropertiesResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ImageRegistryCredentialResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.InitContainerDefinitionResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.IpAddressResponse
import com.pulumi.azurenative.containerinstance.kotlin.outputs.VolumeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ConfidentialComputePropertiesResponse.Companion.toKotlin as confidentialComputePropertiesResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupDiagnosticsResponse.Companion.toKotlin as containerGroupDiagnosticsResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupIdentityResponse.Companion.toKotlin as containerGroupIdentityResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupPropertiesResponseInstanceView.Companion.toKotlin as containerGroupPropertiesResponseInstanceViewToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerGroupSubnetIdResponse.Companion.toKotlin as containerGroupSubnetIdResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerResponse.Companion.toKotlin as containerResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.DeploymentExtensionSpecResponse.Companion.toKotlin as deploymentExtensionSpecResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.DnsConfigurationResponse.Companion.toKotlin as dnsConfigurationResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin as encryptionPropertiesResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.ImageRegistryCredentialResponse.Companion.toKotlin as imageRegistryCredentialResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.InitContainerDefinitionResponse.Companion.toKotlin as initContainerDefinitionResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.IpAddressResponse.Companion.toKotlin as ipAddressResponseToKotlin
import com.pulumi.azurenative.containerinstance.kotlin.outputs.VolumeResponse.Companion.toKotlin as volumeResponseToKotlin

/**
 * Builder for [ContainerGroup].
 */
@PulumiTagMarker
public class ContainerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerGroupArgs = ContainerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerGroupArgsBuilder.() -> Unit) {
        val builder = ContainerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContainerGroup {
        val builtJavaResource =
            com.pulumi.azurenative.containerinstance.ContainerGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContainerGroup(builtJavaResource)
    }
}

/**
 * A container group.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-08-01-preview, 2017-12-01-preview, 2021-03-01, 2021-07-01, 2023-02-01-preview.
 * ## Example Usage
 * ### ConfidentialContainerGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ConfidentialComputeProperties = new AzureNative.ContainerInstance.Inputs.ConfidentialComputePropertiesArgs
 *         {
 *             CcePolicy = "eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19",
 *         },
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new() { },
 *                 EnvironmentVariables = new() { },
 *                 Image = "confiimage",
 *                 Name = "accdemo",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.ContainerInstance.Inputs.ContainerPortArgs
 *                     {
 *                         Port = 8000,
 *                     },
 *                 },
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1.5,
 *                     },
 *                 },
 *                 SecurityContext = new AzureNative.ContainerInstance.Inputs.SecurityContextDefinitionArgs
 *                 {
 *                     Capabilities = new AzureNative.ContainerInstance.Inputs.SecurityContextCapabilitiesDefinitionArgs
 *                     {
 *                         Add = new[]
 *                         {
 *                             "CAP_NET_ADMIN",
 *                         },
 *                     },
 *                     Privileged = false,
 *                 },
 *             },
 *         },
 *         ImageRegistryCredentials = new[] {},
 *         IpAddress = new AzureNative.ContainerInstance.Inputs.IpAddressArgs
 *         {
 *             Ports = new[]
 *             {
 *                 new AzureNative.ContainerInstance.Inputs.PortArgs
 *                 {
 *                     Port = 8000,
 *                     Protocol = AzureNative.ContainerInstance.ContainerGroupNetworkProtocol.TCP,
 *                 },
 *             },
 *             Type = AzureNative.ContainerInstance.ContainerGroupIpAddressType.Public,
 *         },
 *         Location = "westeurope",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         ResourceGroupName = "demo",
 *         Sku = AzureNative.ContainerInstance.ContainerGroupSku.Confidential,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ConfidentialComputeProperties: &containerinstance.ConfidentialComputePropertiesArgs{
 * 				CcePolicy: pulumi.String("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19"),
 * 			},
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command:              pulumi.StringArray{},
 * 					EnvironmentVariables: containerinstance.EnvironmentVariableArray{},
 * 					Image:                pulumi.String("confiimage"),
 * 					Name:                 pulumi.String("accdemo"),
 * 					Ports: containerinstance.ContainerPortArray{
 * 						&containerinstance.ContainerPortArgs{
 * 							Port: pulumi.Int(8000),
 * 						},
 * 					},
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1.5),
 * 						},
 * 					},
 * 					SecurityContext: &containerinstance.SecurityContextDefinitionArgs{
 * 						Capabilities: &containerinstance.SecurityContextCapabilitiesDefinitionArgs{
 * 							Add: pulumi.StringArray{
 * 								pulumi.String("CAP_NET_ADMIN"),
 * 							},
 * 						},
 * 						Privileged: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			ImageRegistryCredentials: containerinstance.ImageRegistryCredentialArray{},
 * 			IpAddress: &containerinstance.IpAddressArgs{
 * 				Ports: containerinstance.PortArray{
 * 					&containerinstance.PortArgs{
 * 						Port:     pulumi.Int(8000),
 * 						Protocol: pulumi.String(containerinstance.ContainerGroupNetworkProtocolTCP),
 * 					},
 * 				},
 * 				Type: pulumi.String(containerinstance.ContainerGroupIpAddressTypePublic),
 * 			},
 * 			Location:          pulumi.String("westeurope"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			Sku:               pulumi.String(containerinstance.ContainerGroupSkuConfidential),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .confidentialComputeProperties(ConfidentialComputePropertiesArgs.builder()
 *                 .ccePolicy("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19")
 *                 .build())
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command()
 *                 .environmentVariables()
 *                 .image("confiimage")
 *                 .name("accdemo")
 *                 .ports(ContainerPortArgs.builder()
 *                     .port(8000)
 *                     .build())
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1.5)
 *                         .build())
 *                     .build())
 *                 .securityContext(SecurityContextDefinitionArgs.builder()
 *                     .capabilities(SecurityContextCapabilitiesDefinitionArgs.builder()
 *                         .add("CAP_NET_ADMIN")
 *                         .build())
 *                     .privileged(false)
 *                     .build())
 *                 .build())
 *             .imageRegistryCredentials()
 *             .ipAddress(IpAddressArgs.builder()
 *                 .ports(PortArgs.builder()
 *                     .port(8000)
 *                     .protocol("TCP")
 *                     .build())
 *                 .type("Public")
 *                 .build())
 *             .location("westeurope")
 *             .osType("Linux")
 *             .resourceGroupName("demo")
 *             .sku("Confidential")
 *             .build());
 *     }
 * }
 * ```
 * ### ContainerGroupCreateWithExtensions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new() { },
 *                 EnvironmentVariables = new() { },
 *                 Image = "nginx",
 *                 Name = "demo1",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.ContainerInstance.Inputs.ContainerPortArgs
 *                     {
 *                         Port = 80,
 *                     },
 *                 },
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1.5,
 *                     },
 *                 },
 *             },
 *         },
 *         Extensions = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.DeploymentExtensionSpecArgs
 *             {
 *                 ExtensionType = "kube-proxy",
 *                 Name = "kube-proxy",
 *                 ProtectedSettings = new Dictionary<string, object?>
 *                 {
 *                     ["kubeConfig"] = "<kubeconfig encoded string>",
 *                 },
 *                 Settings = new Dictionary<string, object?>
 *                 {
 *                     ["clusterCidr"] = "10.240.0.0/16",
 *                     ["kubeVersion"] = "v1.9.10",
 *                 },
 *                 Version = "1.0",
 *             },
 *             new AzureNative.ContainerInstance.Inputs.DeploymentExtensionSpecArgs
 *             {
 *                 ExtensionType = "realtime-metrics",
 *                 Name = "vk-realtime-metrics",
 *                 Version = "1.0",
 *             },
 *         },
 *         ImageRegistryCredentials = new[] {},
 *         IpAddress = new AzureNative.ContainerInstance.Inputs.IpAddressArgs
 *         {
 *             Ports = new[]
 *             {
 *                 new AzureNative.ContainerInstance.Inputs.PortArgs
 *                 {
 *                     Port = 80,
 *                     Protocol = AzureNative.ContainerInstance.ContainerGroupNetworkProtocol.TCP,
 *                 },
 *             },
 *             Type = AzureNative.ContainerInstance.ContainerGroupIpAddressType.Private,
 *         },
 *         Location = "eastus2",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         ResourceGroupName = "demo",
 *         SubnetIds = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerGroupSubnetIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command:              pulumi.StringArray{},
 * 					EnvironmentVariables: containerinstance.EnvironmentVariableArray{},
 * 					Image:                pulumi.String("nginx"),
 * 					Name:                 pulumi.String("demo1"),
 * 					Ports: containerinstance.ContainerPortArray{
 * 						&containerinstance.ContainerPortArgs{
 * 							Port: pulumi.Int(80),
 * 						},
 * 					},
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1.5),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Extensions: containerinstance.DeploymentExtensionSpecArray{
 * 				&containerinstance.DeploymentExtensionSpecArgs{
 * 					ExtensionType: pulumi.String("kube-proxy"),
 * 					Name:          pulumi.String("kube-proxy"),
 * 					ProtectedSettings: pulumi.Any(map[string]interface{}{
 * 						"kubeConfig": "<kubeconfig encoded string>",
 * 					}),
 * 					Settings: pulumi.Any(map[string]interface{}{
 * 						"clusterCidr": "10.240.0.0/16",
 * 						"kubeVersion": "v1.9.10",
 * 					}),
 * 					Version: pulumi.String("1.0"),
 * 				},
 * 				&containerinstance.DeploymentExtensionSpecArgs{
 * 					ExtensionType: pulumi.String("realtime-metrics"),
 * 					Name:          pulumi.String("vk-realtime-metrics"),
 * 					Version:       pulumi.String("1.0"),
 * 				},
 * 			},
 * 			ImageRegistryCredentials: containerinstance.ImageRegistryCredentialArray{},
 * 			IpAddress: &containerinstance.IpAddressArgs{
 * 				Ports: containerinstance.PortArray{
 * 					&containerinstance.PortArgs{
 * 						Port:     pulumi.Int(80),
 * 						Protocol: pulumi.String(containerinstance.ContainerGroupNetworkProtocolTCP),
 * 					},
 * 				},
 * 				Type: pulumi.String(containerinstance.ContainerGroupIpAddressTypePrivate),
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			SubnetIds: containerinstance.ContainerGroupSubnetIdArray{
 * 				&containerinstance.ContainerGroupSubnetIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command()
 *                 .environmentVariables()
 *                 .image("nginx")
 *                 .name("demo1")
 *                 .ports(ContainerPortArgs.builder()
 *                     .port(80)
 *                     .build())
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1.5)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extensions(
 *                 DeploymentExtensionSpecArgs.builder()
 *                     .extensionType("kube-proxy")
 *                     .name("kube-proxy")
 *                     .protectedSettings(Map.of("kubeConfig", "<kubeconfig encoded string>"))
 *                     .settings(Map.ofEntries(
 *                         Map.entry("clusterCidr", "10.240.0.0/16"),
 *                         Map.entry("kubeVersion", "v1.9.10")
 *                     ))
 *                     .version("1.0")
 *                     .build(),
 *                 DeploymentExtensionSpecArgs.builder()
 *                     .extensionType("realtime-metrics")
 *                     .name("vk-realtime-metrics")
 *                     .version("1.0")
 *                     .build())
 *             .imageRegistryCredentials()
 *             .ipAddress(IpAddressArgs.builder()
 *                 .ports(PortArgs.builder()
 *                     .port(80)
 *                     .protocol("TCP")
 *                     .build())
 *                 .type("Private")
 *                 .build())
 *             .location("eastus2")
 *             .osType("Linux")
 *             .resourceGroupName("demo")
 *             .subnetIds(ContainerGroupSubnetIdArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ContainerGroupsCreateWithPriority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new[]
 *                 {
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 10",
 *                 },
 *                 Image = "alpine:latest",
 *                 Name = "test-container-001",
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1,
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         Priority = AzureNative.ContainerInstance.ContainerGroupPriority.Spot,
 *         ResourceGroupName = "demo",
 *         RestartPolicy = AzureNative.ContainerInstance.ContainerGroupRestartPolicy.Never,
 *         Sku = AzureNative.ContainerInstance.ContainerGroupSku.Standard,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command: pulumi.StringArray{
 * 						pulumi.String("/bin/sh"),
 * 						pulumi.String("-c"),
 * 						pulumi.String("sleep 10"),
 * 					},
 * 					Image: pulumi.String("alpine:latest"),
 * 					Name:  pulumi.String("test-container-001"),
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			Priority:          pulumi.String(containerinstance.ContainerGroupPrioritySpot),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			RestartPolicy:     pulumi.String(containerinstance.ContainerGroupRestartPolicyNever),
 * 			Sku:               pulumi.String(containerinstance.ContainerGroupSkuStandard),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command(
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 10")
 *                 .image("alpine:latest")
 *                 .name("test-container-001")
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .osType("Linux")
 *             .priority("Spot")
 *             .resourceGroupName("demo")
 *             .restartPolicy("Never")
 *             .sku("Standard")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerinstance:ContainerGroup demo1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}
 * ```
 */
public class ContainerGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.containerinstance.ContainerGroup,
) : KotlinCustomResource(javaResource, ContainerGroupMapper) {
    /**
     * The properties for confidential container group
     */
    public val confidentialComputeProperties: Output<ConfidentialComputePropertiesResponse>?
        get() = javaResource.confidentialComputeProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> confidentialComputePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The containers within the container group.
     */
    public val containers: Output<List<ContainerResponse>>
        get() = javaResource.containers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerResponseToKotlin(args0)
                })
            })
        })

    /**
     * The diagnostic information for a container group.
     */
    public val diagnostics: Output<ContainerGroupDiagnosticsResponse>?
        get() = javaResource.diagnostics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerGroupDiagnosticsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The DNS config information for a container group.
     */
    public val dnsConfig: Output<DnsConfigurationResponse>?
        get() = javaResource.dnsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dnsConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The encryption properties for a container group.
     */
    public val encryptionProperties: Output<EncryptionPropertiesResponse>?
        get() = javaResource.encryptionProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> encryptionPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * extensions used by virtual kubelet
     */
    public val extensions: Output<List<DeploymentExtensionSpecResponse>>?
        get() = javaResource.extensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> deploymentExtensionSpecResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The identity of the container group, if configured.
     */
    public val identity: Output<ContainerGroupIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerGroupIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The image registry credentials by which the container group is created from.
     */
    public val imageRegistryCredentials: Output<List<ImageRegistryCredentialResponse>>?
        get() = javaResource.imageRegistryCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        imageRegistryCredentialResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The init containers for a container group.
     */
    public val initContainers: Output<List<InitContainerDefinitionResponse>>?
        get() = javaResource.initContainers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        initContainerDefinitionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The instance view of the container group. Only valid in response.
     */
    public val instanceView: Output<ContainerGroupPropertiesResponseInstanceView>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                containerGroupPropertiesResponseInstanceViewToKotlin(args0)
            })
        })

    /**
     * The IP address type of the container group.
     */
    public val ipAddress: Output<IpAddressResponse>?
        get() = javaResource.ipAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ipAddressResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The operating system type required by the containers in the container group.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * The priority of the container group.
     */
    public val priority: Output<String>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the container group. This only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    public val restartPolicy: Output<String>?
        get() = javaResource.restartPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU for a container group.
     */
    public val sku: Output<String>?
        get() = javaResource.sku().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The subnet resource IDs for a container group.
     */
    public val subnetIds: Output<List<ContainerGroupSubnetIdResponse>>?
        get() = javaResource.subnetIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> containerGroupSubnetIdResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of volumes that can be mounted by containers in this container group.
     */
    public val volumes: Output<List<VolumeResponse>>?
        get() = javaResource.volumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> volumeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The zones for the container group.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ContainerGroupMapper : ResourceMapper<ContainerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerinstance.ContainerGroup::class == javaResource::class

    override fun map(javaResource: Resource): ContainerGroup = ContainerGroup(
        javaResource as
            com.pulumi.azurenative.containerinstance.ContainerGroup,
    )
}

/**
 * @see [ContainerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerGroup].
 */
public suspend fun containerGroup(
    name: String,
    block: suspend ContainerGroupResourceBuilder.() -> Unit,
): ContainerGroup {
    val builder = ContainerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerGroup(name: String): ContainerGroup {
    val builder = ContainerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
