@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU of the GPU resource.
 */
public enum class GpuSku(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.GpuSku,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.GpuSku> {
    K80(com.pulumi.azurenative.containerinstance.enums.GpuSku.K80),
    P100(com.pulumi.azurenative.containerinstance.enums.GpuSku.P100),
    V100(com.pulumi.azurenative.containerinstance.enums.GpuSku.V100),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.GpuSku = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.GpuSku): GpuSku =
            GpuSku.values().first { it.javaValue == javaType }
    }
}
