@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operating system type required by the containers in the container group.
 */
public enum class OperatingSystemTypes(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes> {
    Windows(com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes.Windows),
    Linux(com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes.Linux),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.OperatingSystemTypes):
            OperatingSystemTypes = OperatingSystemTypes.values().first { it.javaValue == javaType }
    }
}
