@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A container instance.
 * @property command The commands to execute within the container instance in exec form.
 * @property environmentVariables The environment variables to set in the container instance.
 * @property image The name of the image used to create the container instance.
 * @property livenessProbe The liveness probe.
 * @property name The user-provided name of the container instance.
 * @property ports The exposed ports on the container instance.
 * @property readinessProbe The readiness probe.
 * @property resources The resource requirements of the container instance.
 * @property securityContext The container security properties.
 * @property volumeMounts The volume mounts available to the container instance.
 */
public data class ContainerArgs(
    public val command: Output<List<String>>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>,
    public val livenessProbe: Output<ContainerProbeArgs>? = null,
    public val name: Output<String>,
    public val ports: Output<List<ContainerPortArgs>>? = null,
    public val readinessProbe: Output<ContainerProbeArgs>? = null,
    public val resources: Output<ResourceRequirementsArgs>,
    public val securityContext: Output<SecurityContextDefinitionArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerArgs.builder()
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image.applyValue({ args0 -> args0 }))
            .livenessProbe(livenessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .readinessProbe(readinessProbe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resources(resources.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityContext(securityContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerArgs].
 */
@PulumiTagMarker
public class ContainerArgsBuilder internal constructor() {
    private var command: Output<List<String>>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var livenessProbe: Output<ContainerProbeArgs>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<ContainerPortArgs>>? = null

    private var readinessProbe: Output<ContainerProbeArgs>? = null

    private var resources: Output<ResourceRequirementsArgs>? = null

    private var securityContext: Output<SecurityContextDefinitionArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value The commands to execute within the container instance in exec form.
     */
    @JvmName("xhlaotrewjsucdqw")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("spvndydfwddgmxnb")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values The commands to execute within the container instance in exec form.
     */
    @JvmName("pprnfptvpnohtfdi")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value The environment variables to set in the container instance.
     */
    @JvmName("bhhqssbdiykjqkrc")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("gpoidjkxhpbuosuw")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to set in the container instance.
     */
    @JvmName("qwmownkrafdjfdfu")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value The name of the image used to create the container instance.
     */
    @JvmName("yvdwnlnvfvcsgljs")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The liveness probe.
     */
    @JvmName("yvtyqfljfxcwxdsh")
    public suspend fun livenessProbe(`value`: Output<ContainerProbeArgs>) {
        this.livenessProbe = value
    }

    /**
     * @param value The user-provided name of the container instance.
     */
    @JvmName("xmpeuaoyoqrpksab")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The exposed ports on the container instance.
     */
    @JvmName("vavcsrwbbigcokau")
    public suspend fun ports(`value`: Output<List<ContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("kwsxgdyfucsefsjw")
    public suspend fun ports(vararg values: Output<ContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The exposed ports on the container instance.
     */
    @JvmName("ctnryogxsqbxaeyl")
    public suspend fun ports(values: List<Output<ContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value The readiness probe.
     */
    @JvmName("culdgbjyfgrandcb")
    public suspend fun readinessProbe(`value`: Output<ContainerProbeArgs>) {
        this.readinessProbe = value
    }

    /**
     * @param value The resource requirements of the container instance.
     */
    @JvmName("ujakxqfavvvxipsm")
    public suspend fun resources(`value`: Output<ResourceRequirementsArgs>) {
        this.resources = value
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("qbfathmwcivnysia")
    public suspend fun securityContext(`value`: Output<SecurityContextDefinitionArgs>) {
        this.securityContext = value
    }

    /**
     * @param value The volume mounts available to the container instance.
     */
    @JvmName("exfcggnfvefkrriw")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("woqmjncuuffevgia")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The volume mounts available to the container instance.
     */
    @JvmName("ylbntddmmgijecob")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The commands to execute within the container instance in exec form.
     */
    @JvmName("fwjimffjobyjnjfs")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values The commands to execute within the container instance in exec form.
     */
    @JvmName("lcpgdyygkwdpvnrp")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value The environment variables to set in the container instance.
     */
    @JvmName("oohliegkxbrcwkqs")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("ooyqevbbloasvomq")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("ftkvikndrjrhhyby")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the container instance.
     */
    @JvmName("rxefubbhwmpfjpef")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to set in the container instance.
     */
    @JvmName("kavluwikibkbxhgm")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The name of the image used to create the container instance.
     */
    @JvmName("iayacehpdkjkncld")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The liveness probe.
     */
    @JvmName("hfgcyxlsmxxugtqr")
    public suspend fun livenessProbe(`value`: ContainerProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbe = mapped
    }

    /**
     * @param argument The liveness probe.
     */
    @JvmName("hivirmwydhfkpvpb")
    public suspend fun livenessProbe(argument: suspend ContainerProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.livenessProbe = mapped
    }

    /**
     * @param value The user-provided name of the container instance.
     */
    @JvmName("fxlfeoyrjxjhdcpj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The exposed ports on the container instance.
     */
    @JvmName("ydmicsvfksjbxffn")
    public suspend fun ports(`value`: List<ContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("ocaomoqmqpvbpqpq")
    public suspend fun ports(argument: List<suspend ContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("cvxekeepqvfcmrbo")
    public suspend fun ports(vararg argument: suspend ContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The exposed ports on the container instance.
     */
    @JvmName("cqubjfcmtkhvoshb")
    public suspend fun ports(argument: suspend ContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerPortArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The exposed ports on the container instance.
     */
    @JvmName("jkctbjvkskbvfwnj")
    public suspend fun ports(vararg values: ContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value The readiness probe.
     */
    @JvmName("xiuuiquyomyrfxts")
    public suspend fun readinessProbe(`value`: ContainerProbeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbe = mapped
    }

    /**
     * @param argument The readiness probe.
     */
    @JvmName("hyhmyalavcpvpdut")
    public suspend fun readinessProbe(argument: suspend ContainerProbeArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerProbeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readinessProbe = mapped
    }

    /**
     * @param value The resource requirements of the container instance.
     */
    @JvmName("gjuqbikmcknwdovl")
    public suspend fun resources(`value`: ResourceRequirementsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument The resource requirements of the container instance.
     */
    @JvmName("chdbnanbaiqggjte")
    public suspend fun resources(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("papeulwkpdcevhvv")
    public suspend fun securityContext(`value`: SecurityContextDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContext = mapped
    }

    /**
     * @param argument The container security properties.
     */
    @JvmName("cjsxkcypvusvgoah")
    public suspend
    fun securityContext(argument: suspend SecurityContextDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContextDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityContext = mapped
    }

    /**
     * @param value The volume mounts available to the container instance.
     */
    @JvmName("lewubudwgylgited")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("urorjbyxfsvuywxd")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("xxkjcofkhaaicxcp")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the container instance.
     */
    @JvmName("ikrokavcteimybjr")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The volume mounts available to the container instance.
     */
    @JvmName("hnwqchrekyrfdqup")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): ContainerArgs = ContainerArgs(
        command = command,
        environmentVariables = environmentVariables,
        image = image ?: throw PulumiNullFieldException("image"),
        livenessProbe = livenessProbe,
        name = name ?: throw PulumiNullFieldException("name"),
        ports = ports,
        readinessProbe = readinessProbe,
        resources = resources ?: throw PulumiNullFieldException("resources"),
        securityContext = securityContext,
        volumeMounts = volumeMounts,
    )
}
