@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerGroupIdentityArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity for the container group.
 * @property type The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the container group.
 * @property userAssignedIdentities The list of user identities associated with the container group.
 */
public data class ContainerGroupIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerGroupIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerGroupIdentityArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerGroupIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerGroupIdentityArgs].
 */
@PulumiTagMarker
public class ContainerGroupIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the container group.
     */
    @JvmName("xapyiadhorevfldy")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the container group.
     */
    @JvmName("nnuoknxosfmypnyw")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("oigrfaxegesrduch")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The list of user identities associated with the container group.
     */
    @JvmName("iivwugdusiqhaxef")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the container group.
     */
    @JvmName("rctvgjmehcciriux")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the container group.
     */
    @JvmName("cvannlcqmorrmwry")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the container group.
     */
    @JvmName("cujnvwmxhdumcbdd")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ContainerGroupIdentityArgs = ContainerGroupIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
