@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container group subnet information.
 * @property id Resource ID of virtual network and subnet.
 * @property name Friendly name for the subnet.
 */
public data class ContainerGroupSubnetIdArgs(
    public val id: Output<String>,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerGroupSubnetIdArgs].
 */
@PulumiTagMarker
public class ContainerGroupSubnetIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Resource ID of virtual network and subnet.
     */
    @JvmName("ojwftpwmqxupochc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Friendly name for the subnet.
     */
    @JvmName("gimjqsxjaycegjxi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID of virtual network and subnet.
     */
    @JvmName("pryyaimgtvrqrxpq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Friendly name for the subnet.
     */
    @JvmName("cyslchobwsgyksxm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ContainerGroupSubnetIdArgs = ContainerGroupSubnetIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        name = name,
    )
}
