@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerHttpGetArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.Scheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The container Http Get settings, for liveness or readiness probe
 * @property httpHeaders The HTTP headers.
 * @property path The path to probe.
 * @property port The port number to probe.
 * @property scheme The scheme.
 */
public data class ContainerHttpGetArgs(
    public val httpHeaders: Output<List<HttpHeaderArgs>>? = null,
    public val path: Output<String>? = null,
    public val port: Output<Int>,
    public val scheme: Output<Either<String, Scheme>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerHttpGetArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerHttpGetArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerHttpGetArgs.builder()
            .httpHeaders(
                httpHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .scheme(
                scheme?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerHttpGetArgs].
 */
@PulumiTagMarker
public class ContainerHttpGetArgsBuilder internal constructor() {
    private var httpHeaders: Output<List<HttpHeaderArgs>>? = null

    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var scheme: Output<Either<String, Scheme>>? = null

    /**
     * @param value The HTTP headers.
     */
    @JvmName("lainafhvlsuuncqa")
    public suspend fun httpHeaders(`value`: Output<List<HttpHeaderArgs>>) {
        this.httpHeaders = value
    }

    @JvmName("acgmdhebjboshuea")
    public suspend fun httpHeaders(vararg values: Output<HttpHeaderArgs>) {
        this.httpHeaders = Output.all(values.asList())
    }

    /**
     * @param values The HTTP headers.
     */
    @JvmName("nvhmtwjoidtfivcn")
    public suspend fun httpHeaders(values: List<Output<HttpHeaderArgs>>) {
        this.httpHeaders = Output.all(values)
    }

    /**
     * @param value The path to probe.
     */
    @JvmName("aekymvktbxinxxxg")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port number to probe.
     */
    @JvmName("hlvvidkajosvdtgh")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The scheme.
     */
    @JvmName("xebvqocohxnxfrnf")
    public suspend fun scheme(`value`: Output<Either<String, Scheme>>) {
        this.scheme = value
    }

    /**
     * @param value The HTTP headers.
     */
    @JvmName("gxwpqnarvpqwhogi")
    public suspend fun httpHeaders(`value`: List<HttpHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param argument The HTTP headers.
     */
    @JvmName("kokjnidkpysbvuws")
    public suspend fun httpHeaders(argument: List<suspend HttpHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HttpHeaderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument The HTTP headers.
     */
    @JvmName("xnqsldwfdbayokhc")
    public suspend fun httpHeaders(vararg argument: suspend HttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HttpHeaderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param argument The HTTP headers.
     */
    @JvmName("xgwrasvdctmyhpvv")
    public suspend fun httpHeaders(argument: suspend HttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HttpHeaderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.httpHeaders = mapped
    }

    /**
     * @param values The HTTP headers.
     */
    @JvmName("hkdwobjpdtbxxutu")
    public suspend fun httpHeaders(vararg values: HttpHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaders = mapped
    }

    /**
     * @param value The path to probe.
     */
    @JvmName("lmqfxpcbujvthfkx")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port number to probe.
     */
    @JvmName("unrdyjlfsjmfvkes")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The scheme.
     */
    @JvmName("ygphfphguxshfhlf")
    public suspend fun scheme(`value`: Either<String, Scheme>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The scheme.
     */
    @JvmName("flpvjgtfamywkawo")
    public fun scheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Scheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The scheme.
     */
    @JvmName("mpcmwoqifvvlpqtn")
    public fun scheme(`value`: Scheme) {
        val toBeMapped = Either.ofRight<String, Scheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    internal fun build(): ContainerHttpGetArgs = ContainerHttpGetArgs(
        httpHeaders = httpHeaders,
        path = path,
        port = port ?: throw PulumiNullFieldException("port"),
        scheme = scheme,
    )
}
