@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.GetContainerGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerGroupName The name of the container group.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetContainerGroupPlainArgs(
    public val containerGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.GetContainerGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.GetContainerGroupPlainArgs =
        com.pulumi.azurenative.containerinstance.inputs.GetContainerGroupPlainArgs.builder()
            .containerGroupName(containerGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerGroupPlainArgs].
 */
@PulumiTagMarker
public class GetContainerGroupPlainArgsBuilder internal constructor() {
    private var containerGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the container group.
     */
    @JvmName("sgxwodochxrxcpcj")
    public suspend fun containerGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("otuywfdwqevhcfvm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContainerGroupPlainArgs = GetContainerGroupPlainArgs(
        containerGroupName = containerGroupName ?: throw PulumiNullFieldException("containerGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
