@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.InitContainerDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The init container definition.
 * @property command The command to execute within the init container in exec form.
 * @property environmentVariables The environment variables to set in the init container.
 * @property image The image of the init container.
 * @property name The name for the init container.
 * @property securityContext The container security properties.
 * @property volumeMounts The volume mounts available to the init container.
 */
public data class InitContainerDefinitionArgs(
    public val command: Output<List<String>>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val image: Output<String>? = null,
    public val name: Output<String>,
    public val securityContext: Output<SecurityContextDefinitionArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.InitContainerDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.InitContainerDefinitionArgs =
        com.pulumi.azurenative.containerinstance.inputs.InitContainerDefinitionArgs.builder()
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .securityContext(securityContext?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InitContainerDefinitionArgs].
 */
@PulumiTagMarker
public class InitContainerDefinitionArgsBuilder internal constructor() {
    private var command: Output<List<String>>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var name: Output<String>? = null

    private var securityContext: Output<SecurityContextDefinitionArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value The command to execute within the init container in exec form.
     */
    @JvmName("kxcvjoobbwpntcxx")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("gvdyiwdqhoodxoxk")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values The command to execute within the init container in exec form.
     */
    @JvmName("unyuslwoaemsvdes")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value The environment variables to set in the init container.
     */
    @JvmName("yqtnmihtvosbjrdx")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("intdogaqybinlxod")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to set in the init container.
     */
    @JvmName("vefktbsgxkmndnqm")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value The image of the init container.
     */
    @JvmName("yktbsdwpnlygogxs")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The name for the init container.
     */
    @JvmName("ivpdetjoatbxxxlo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("biuwmfohqdpwhiue")
    public suspend fun securityContext(`value`: Output<SecurityContextDefinitionArgs>) {
        this.securityContext = value
    }

    /**
     * @param value The volume mounts available to the init container.
     */
    @JvmName("cpqsurnofolltqtd")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("xvqqqvnbypkhtrfa")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The volume mounts available to the init container.
     */
    @JvmName("aumgktnbkstxjser")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The command to execute within the init container in exec form.
     */
    @JvmName("jxvnajhtmeyucmkl")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values The command to execute within the init container in exec form.
     */
    @JvmName("mrbbsddegwhywfnv")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value The environment variables to set in the init container.
     */
    @JvmName("bacpiquookgllkbb")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the init container.
     */
    @JvmName("atgskgdouepmlejs")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the init container.
     */
    @JvmName("ehiatrbylfdsadqf")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to set in the init container.
     */
    @JvmName("ocgtymkncniaojxy")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to set in the init container.
     */
    @JvmName("xntuogqjqdobckmg")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The image of the init container.
     */
    @JvmName("btiarbcmfdgmeueg")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The name for the init container.
     */
    @JvmName("nrmjkmvwexouxfdo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The container security properties.
     */
    @JvmName("rnhsbhdxfjxmrcgs")
    public suspend fun securityContext(`value`: SecurityContextDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContext = mapped
    }

    /**
     * @param argument The container security properties.
     */
    @JvmName("ybotcnsmlcwfjgdw")
    public suspend
    fun securityContext(argument: suspend SecurityContextDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContextDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityContext = mapped
    }

    /**
     * @param value The volume mounts available to the init container.
     */
    @JvmName("phwjvfkguaraljqw")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the init container.
     */
    @JvmName("bsbauwysfhafkfvm")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the init container.
     */
    @JvmName("ucpwryvaoqymnyyk")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The volume mounts available to the init container.
     */
    @JvmName("lrwyfgxdmbnyooux")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The volume mounts available to the init container.
     */
    @JvmName("dlhxdapsawkxsjlt")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): InitContainerDefinitionArgs = InitContainerDefinitionArgs(
        command = command,
        environmentVariables = environmentVariables,
        image = image,
        name = name ?: throw PulumiNullFieldException("name"),
        securityContext = securityContext,
        volumeMounts = volumeMounts,
    )
}
