@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ResourceLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource limits.
 * @property cpu The CPU limit of this container instance.
 * @property gpu The GPU limit of this container instance.
 * @property memoryInGB The memory limit in GB of this container instance.
 */
public data class ResourceLimitsArgs(
    public val cpu: Output<Double>? = null,
    public val gpu: Output<GpuResourceArgs>? = null,
    public val memoryInGB: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ResourceLimitsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ResourceLimitsArgs =
        com.pulumi.azurenative.containerinstance.inputs.ResourceLimitsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .gpu(gpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryInGB(memoryInGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceLimitsArgs].
 */
@PulumiTagMarker
public class ResourceLimitsArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var gpu: Output<GpuResourceArgs>? = null

    private var memoryInGB: Output<Double>? = null

    /**
     * @param value The CPU limit of this container instance.
     */
    @JvmName("jsgrorsenfeltkiu")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The GPU limit of this container instance.
     */
    @JvmName("qfptnsvhymksewne")
    public suspend fun gpu(`value`: Output<GpuResourceArgs>) {
        this.gpu = value
    }

    /**
     * @param value The memory limit in GB of this container instance.
     */
    @JvmName("barpmpnhaycejutl")
    public suspend fun memoryInGB(`value`: Output<Double>) {
        this.memoryInGB = value
    }

    /**
     * @param value The CPU limit of this container instance.
     */
    @JvmName("vinrdtigcdwynwfg")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The GPU limit of this container instance.
     */
    @JvmName("xiotrvmqbtninqsk")
    public suspend fun gpu(`value`: GpuResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param argument The GPU limit of this container instance.
     */
    @JvmName("oyjvorhjkeniqcpv")
    public suspend fun gpu(argument: suspend GpuResourceArgsBuilder.() -> Unit) {
        val toBeMapped = GpuResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gpu = mapped
    }

    /**
     * @param value The memory limit in GB of this container instance.
     */
    @JvmName("dxesjqtepkxuuxnx")
    public suspend fun memoryInGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryInGB = mapped
    }

    internal fun build(): ResourceLimitsArgs = ResourceLimitsArgs(
        cpu = cpu,
        gpu = gpu,
        memoryInGB = memoryInGB,
    )
}
