@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.VolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The properties of the volume.
 * @property azureFile The Azure File volume.
 * @property emptyDir The empty directory volume.
 * @property gitRepo The git repo volume.
 * @property name The name of the volume.
 * @property secret The secret volume.
 */
public data class VolumeArgs(
    public val azureFile: Output<AzureFileVolumeArgs>? = null,
    public val emptyDir: Output<Any>? = null,
    public val gitRepo: Output<GitRepoVolumeArgs>? = null,
    public val name: Output<String>,
    public val secret: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.VolumeArgs =
        com.pulumi.azurenative.containerinstance.inputs.VolumeArgs.builder()
            .azureFile(azureFile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .emptyDir(emptyDir?.applyValue({ args0 -> args0 }))
            .gitRepo(gitRepo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .secret(
                secret?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var azureFile: Output<AzureFileVolumeArgs>? = null

    private var emptyDir: Output<Any>? = null

    private var gitRepo: Output<GitRepoVolumeArgs>? = null

    private var name: Output<String>? = null

    private var secret: Output<Map<String, String>>? = null

    /**
     * @param value The Azure File volume.
     */
    @JvmName("kmlrhchcdnvanhnb")
    public suspend fun azureFile(`value`: Output<AzureFileVolumeArgs>) {
        this.azureFile = value
    }

    /**
     * @param value The empty directory volume.
     */
    @JvmName("sauvekujjaaboeia")
    public suspend fun emptyDir(`value`: Output<Any>) {
        this.emptyDir = value
    }

    /**
     * @param value The git repo volume.
     */
    @JvmName("xblaruxrtvygxwdj")
    public suspend fun gitRepo(`value`: Output<GitRepoVolumeArgs>) {
        this.gitRepo = value
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("xyducgqsjafqbjle")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The secret volume.
     */
    @JvmName("oesppgwjfeicbned")
    public suspend fun secret(`value`: Output<Map<String, String>>) {
        this.secret = value
    }

    /**
     * @param value The Azure File volume.
     */
    @JvmName("chwksdcjymaqirdb")
    public suspend fun azureFile(`value`: AzureFileVolumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFile = mapped
    }

    /**
     * @param argument The Azure File volume.
     */
    @JvmName("jobiktpgpgdbxesg")
    public suspend fun azureFile(argument: suspend AzureFileVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFileVolumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFile = mapped
    }

    /**
     * @param value The empty directory volume.
     */
    @JvmName("pbuhtdenemorjreh")
    public suspend fun emptyDir(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emptyDir = mapped
    }

    /**
     * @param value The git repo volume.
     */
    @JvmName("wxitocornfysiwdv")
    public suspend fun gitRepo(`value`: GitRepoVolumeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitRepo = mapped
    }

    /**
     * @param argument The git repo volume.
     */
    @JvmName("xobytbydoufjvmwe")
    public suspend fun gitRepo(argument: suspend GitRepoVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = GitRepoVolumeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitRepo = mapped
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("aidwrtlxeukyyfgv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The secret volume.
     */
    @JvmName("bpqbbwikfcjcufxi")
    public suspend fun secret(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    /**
     * @param values The secret volume.
     */
    @JvmName("xcgtrxmhoipvdrcc")
    public fun secret(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        azureFile = azureFile,
        emptyDir = emptyDir,
        gitRepo = gitRepo,
        name = name ?: throw PulumiNullFieldException("name"),
        secret = secret,
    )
}
