@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A container instance.
 * @property command The commands to execute within the container instance in exec form.
 * @property environmentVariables The environment variables to set in the container instance.
 * @property image The name of the image used to create the container instance.
 * @property instanceView The instance view of the container instance. Only valid in response.
 * @property livenessProbe The liveness probe.
 * @property name The user-provided name of the container instance.
 * @property ports The exposed ports on the container instance.
 * @property readinessProbe The readiness probe.
 * @property resources The resource requirements of the container instance.
 * @property securityContext The container security properties.
 * @property volumeMounts The volume mounts available to the container instance.
 */
public data class ContainerResponse(
    public val command: List<String>? = null,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val image: String,
    public val instanceView: ContainerPropertiesResponseInstanceView,
    public val livenessProbe: ContainerProbeResponse? = null,
    public val name: String,
    public val ports: List<ContainerPortResponse>? = null,
    public val readinessProbe: ContainerProbeResponse? = null,
    public val resources: ResourceRequirementsResponse,
    public val securityContext: SecurityContextDefinitionResponse? = null,
    public val volumeMounts: List<VolumeMountResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerResponse):
            ContainerResponse = ContainerResponse(
            command = javaType.command().map({ args0 -> args0 }),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image(),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerPropertiesResponseInstanceView.Companion.toKotlin(args0)
            }),
            livenessProbe = javaType.livenessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerProbeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerPortResponse.Companion.toKotlin(args0)
                })
            }),
            readinessProbe = javaType.readinessProbe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerProbeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resources = javaType.resources().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
            }),
            securityContext = javaType.securityContext().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.SecurityContextDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.VolumeMountResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
