@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A container group or container instance event.
 * @property count The count of the event.
 * @property firstTimestamp The date-time of the earliest logged event.
 * @property lastTimestamp The date-time of the latest logged event.
 * @property message The event message.
 * @property name The event name.
 * @property type The event type.
 */
public data class EventResponse(
    public val count: Int,
    public val firstTimestamp: String,
    public val lastTimestamp: String,
    public val message: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.EventResponse):
            EventResponse = EventResponse(
            count = javaType.count(),
            firstTimestamp = javaType.firstTimestamp(),
            lastTimestamp = javaType.lastTimestamp(),
            message = javaType.message(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
