@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The resource limits.
 * @property cpu The CPU limit of this container instance.
 * @property gpu The GPU limit of this container instance.
 * @property memoryInGB The memory limit in GB of this container instance.
 */
public data class ResourceLimitsResponse(
    public val cpu: Double? = null,
    public val gpu: GpuResourceResponse? = null,
    public val memoryInGB: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ResourceLimitsResponse):
            ResourceLimitsResponse = ResourceLimitsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            gpu = javaType.gpu().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.GpuResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            memoryInGB = javaType.memoryInGB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
