@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Suppress

/**
 * The resource requirements.
 * @property limits The resource limits of this container instance.
 * @property requests The resource requests of this container instance.
 */
public data class ResourceRequirementsResponse(
    public val limits: ResourceLimitsResponse? = null,
    public val requests: ResourceRequestsResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ResourceRequirementsResponse):
            ResourceRequirementsResponse = ResourceRequirementsResponse(
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ResourceLimitsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requests = javaType.requests().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.ResourceRequestsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
