@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.CacheRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An object that represents a cache rule for a container registry.
 * Azure REST API version: 2023-01-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### CacheRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cacheRule = new AzureNative.ContainerRegistry.CacheRule("cacheRule", new()
 *     {
 *         CacheRuleName = "myCacheRule",
 *         CredentialSetResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/credentialSets/myCredentialSet",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceRepository = "docker.io/library/hello-world",
 *         TargetRepository = "cached-docker-hub/hello-world",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewCacheRule(ctx, "cacheRule", &containerregistry.CacheRuleArgs{
 * 			CacheRuleName:           pulumi.String("myCacheRule"),
 * 			CredentialSetResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/credentialSets/myCredentialSet"),
 * 			RegistryName:            pulumi.String("myRegistry"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			SourceRepository:        pulumi.String("docker.io/library/hello-world"),
 * 			TargetRepository:        pulumi.String("cached-docker-hub/hello-world"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.CacheRule;
 * import com.pulumi.azurenative.containerregistry.CacheRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cacheRule = new CacheRule("cacheRule", CacheRuleArgs.builder()
 *             .cacheRuleName("myCacheRule")
 *             .credentialSetResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/credentialSets/myCredentialSet")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceRepository("docker.io/library/hello-world")
 *             .targetRepository("cached-docker-hub/hello-world")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:CacheRule myCacheRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/cacheRules/{cacheRuleName}
 * ```
 * @property cacheRuleName The name of the cache rule.
 * @property credentialSetResourceId The ARM resource ID of the credential store which is associated with the cache rule.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceRepository Source repository pulled from upstream.
 * @property targetRepository Target repository specified in docker pull command.
 * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
 */
public data class CacheRuleArgs(
    public val cacheRuleName: Output<String>? = null,
    public val credentialSetResourceId: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceRepository: Output<String>? = null,
    public val targetRepository: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.CacheRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.CacheRuleArgs =
        com.pulumi.azurenative.containerregistry.CacheRuleArgs.builder()
            .cacheRuleName(cacheRuleName?.applyValue({ args0 -> args0 }))
            .credentialSetResourceId(credentialSetResourceId?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceRepository(sourceRepository?.applyValue({ args0 -> args0 }))
            .targetRepository(targetRepository?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheRuleArgs].
 */
@PulumiTagMarker
public class CacheRuleArgsBuilder internal constructor() {
    private var cacheRuleName: Output<String>? = null

    private var credentialSetResourceId: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceRepository: Output<String>? = null

    private var targetRepository: Output<String>? = null

    /**
     * @param value The name of the cache rule.
     */
    @JvmName("jwuiepwxlulycddo")
    public suspend fun cacheRuleName(`value`: Output<String>) {
        this.cacheRuleName = value
    }

    /**
     * @param value The ARM resource ID of the credential store which is associated with the cache rule.
     */
    @JvmName("lobrxyjsdqglhxdh")
    public suspend fun credentialSetResourceId(`value`: Output<String>) {
        this.credentialSetResourceId = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("dwepyufmkmnkkeqp")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pcfskxenahdwtjgw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source repository pulled from upstream.
     */
    @JvmName("pqipqqiicxyqvfsb")
    public suspend fun sourceRepository(`value`: Output<String>) {
        this.sourceRepository = value
    }

    /**
     * @param value Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
     */
    @JvmName("ixwffebksxvuulwv")
    public suspend fun targetRepository(`value`: Output<String>) {
        this.targetRepository = value
    }

    /**
     * @param value The name of the cache rule.
     */
    @JvmName("upjbpmfeyjriufku")
    public suspend fun cacheRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheRuleName = mapped
    }

    /**
     * @param value The ARM resource ID of the credential store which is associated with the cache rule.
     */
    @JvmName("resxpaswssvtlhku")
    public suspend fun credentialSetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialSetResourceId = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("jqlymdmwdrhjmfur")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("brsaaxgbsmvckuxf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source repository pulled from upstream.
     */
    @JvmName("gtqupbdoxbvjdwxj")
    public suspend fun sourceRepository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRepository = mapped
    }

    /**
     * @param value Target repository specified in docker pull command.
     * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
     */
    @JvmName("qvixjimsnighgtiw")
    public suspend fun targetRepository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRepository = mapped
    }

    internal fun build(): CacheRuleArgs = CacheRuleArgs(
        cacheRuleName = cacheRuleName,
        credentialSetResourceId = credentialSetResourceId,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        sourceRepository = sourceRepository,
        targetRepository = targetRepository,
    )
}
