@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ImportPipelineSourcePropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineTriggerPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ImportPipelineSourcePropertiesResponse.Companion.toKotlin as importPipelineSourcePropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineTriggerPropertiesResponse.Companion.toKotlin as pipelineTriggerPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ImportPipeline].
 */
@PulumiTagMarker
public class ImportPipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImportPipelineArgs = ImportPipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImportPipelineArgsBuilder.() -> Unit) {
        val builder = ImportPipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImportPipeline {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.ImportPipeline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ImportPipeline(builtJavaResource)
    }
}

/**
 * An object that represents an import pipeline for a container registry.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ImportPipelineCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importPipeline = new AzureNative.ContainerRegistry.ImportPipeline("importPipeline", new()
 *     {
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         ImportPipelineName = "myImportPipeline",
 *         Location = "westus",
 *         Options = new[]
 *         {
 *             AzureNative.ContainerRegistry.PipelineOptions.OverwriteTags,
 *             AzureNative.ContainerRegistry.PipelineOptions.DeleteSourceBlobOnSuccess,
 *             AzureNative.ContainerRegistry.PipelineOptions.ContinueOnErrors,
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Source = new AzureNative.ContainerRegistry.Inputs.ImportPipelineSourcePropertiesArgs
 *         {
 *             KeyVaultUri = "https://myvault.vault.azure.net/secrets/acrimportsas",
 *             Type = AzureNative.ContainerRegistry.PipelineSourceType.AzureStorageBlobContainer,
 *             Uri = "https://accountname.blob.core.windows.net/containername",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewImportPipeline(ctx, "importPipeline", &containerregistry.ImportPipelineArgs{
 * 			Identity: &containerregistry.IdentityPropertiesArgs{
 * 				Type: containerregistry.ResourceIdentityTypeUserAssigned,
 * 				UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * 					"/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * 				},
 * 			},
 * 			ImportPipelineName: pulumi.String("myImportPipeline"),
 * 			Location:           pulumi.String("westus"),
 * 			Options: pulumi.StringArray{
 * 				pulumi.String(containerregistry.PipelineOptionsOverwriteTags),
 * 				pulumi.String(containerregistry.PipelineOptionsDeleteSourceBlobOnSuccess),
 * 				pulumi.String(containerregistry.PipelineOptionsContinueOnErrors),
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Source: &containerregistry.ImportPipelineSourcePropertiesArgs{
 * 				KeyVaultUri: pulumi.String("https://myvault.vault.azure.net/secrets/acrimportsas"),
 * 				Type:        pulumi.String(containerregistry.PipelineSourceTypeAzureStorageBlobContainer),
 * 				Uri:         pulumi.String("https://accountname.blob.core.windows.net/containername"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ImportPipeline;
 * import com.pulumi.azurenative.containerregistry.ImportPipelineArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.IdentityPropertiesArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.ImportPipelineSourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importPipeline = new ImportPipeline("importPipeline", ImportPipelineArgs.builder()
 *             .identity(IdentityPropertiesArgs.builder()
 *                 .type("UserAssigned")
 *                 .userAssignedIdentities(Map.of("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", ))
 *                 .build())
 *             .importPipelineName("myImportPipeline")
 *             .location("westus")
 *             .options(
 *                 "OverwriteTags",
 *                 "DeleteSourceBlobOnSuccess",
 *                 "ContinueOnErrors")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .source(ImportPipelineSourcePropertiesArgs.builder()
 *                 .keyVaultUri("https://myvault.vault.azure.net/secrets/acrimportsas")
 *                 .type("AzureStorageBlobContainer")
 *                 .uri("https://accountname.blob.core.windows.net/containername")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ImportPipeline myImportPipeline /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/importPipelines/{importPipelineName}
 * ```
 */
public class ImportPipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.ImportPipeline,
) : KotlinCustomResource(javaResource, ImportPipelineMapper) {
    /**
     * The identity of the import pipeline.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the import pipeline.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of all options configured for the pipeline.
     */
    public val options: Output<List<String>>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the pipeline at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The source properties of the import pipeline.
     */
    public val source: Output<ImportPipelineSourcePropertiesResponse>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                importPipelineSourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The properties that describe the trigger of the import pipeline.
     */
    public val trigger: Output<PipelineTriggerPropertiesResponse>?
        get() = javaResource.trigger().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineTriggerPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ImportPipelineMapper : ResourceMapper<ImportPipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.ImportPipeline::class == javaResource::class

    override fun map(javaResource: Resource): ImportPipeline = ImportPipeline(
        javaResource as
            com.pulumi.azurenative.containerregistry.ImportPipeline,
    )
}

/**
 * @see [ImportPipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImportPipeline].
 */
public suspend fun importPipeline(
    name: String,
    block: suspend ImportPipelineResourceBuilder.() -> Unit,
): ImportPipeline {
    val builder = ImportPipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImportPipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun importPipeline(name: String): ImportPipeline {
    val builder = ImportPipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
