@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PrivateEndpointArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PrivateEndpointArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that represents a private endpoint connection for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.ContainerRegistry.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.ContainerRegistry.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = AzureNative.ContainerRegistry.ConnectionStatus.Approved,
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &containerregistry.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myConnection"),
 * 			PrivateLinkServiceConnectionState: &containerregistry.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String(containerregistry.ConnectionStatusApproved),
 * 			},
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.PrivateEndpointConnection;
 * import com.pulumi.azurenative.containerregistry.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myConnection")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Auto-Approved")
 *                 .status("Approved")
 *                 .build())
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:PrivateEndpointConnection myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpoint The resource of private endpoint.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.containerregistry.PrivateEndpointConnectionArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The resource of private endpoint.
     */
    @JvmName("xtdbfesfqhstxaee")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("fhabyqeouqoegarv")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("wdxifrmyckfwpyho")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("utuelbudldcbrqdk")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gfvmxqlargcagkna")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource of private endpoint.
     */
    @JvmName("niohbimeakmhyqkw")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The resource of private endpoint.
     */
    @JvmName("kgyqreupjbihvqxw")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("cwctovexhrulyjpg")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("fuxtqrwhxqfgfacc")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("tkokwqufggwtepuf")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("cjrdhiodakhqcsmo")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bphgcogpydflpspb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
