@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.EncryptionPropertyResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.NetworkRuleSetResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PoliciesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerregistry.kotlin.outputs.EncryptionPropertyResponse.Companion.toKotlin as encryptionPropertyResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin as networkRuleSetResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PoliciesResponse.Companion.toKotlin as policiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse.Companion.toKotlin as statusResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Registry].
 */
@PulumiTagMarker
public class RegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryArgs = RegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryArgsBuilder.() -> Unit) {
        val builder = RegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Registry {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.Registry(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Registry(builtJavaResource)
    }
}

/**
 * An object that represents a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2017-03-01, 2019-05-01, 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### RegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registry = new AzureNative.ContainerRegistry.Registry("registry", new()
 *     {
 *         AdminUserEnabled = true,
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.ContainerRegistry.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ContainerRegistry.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewRegistry(ctx, "registry", &containerregistry.RegistryArgs{
 * 			AdminUserEnabled:  pulumi.Bool(true),
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &containerregistry.SkuArgs{
 * 				Name: pulumi.String(containerregistry.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Registry;
 * import com.pulumi.azurenative.containerregistry.RegistryArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registry = new Registry("registry", RegistryArgs.builder()
 *             .adminUserEnabled(true)
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### RegistryCreateZoneRedundant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registry = new AzureNative.ContainerRegistry.Registry("registry", new()
 *     {
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.ContainerRegistry.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ContainerRegistry.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         ZoneRedundancy = AzureNative.ContainerRegistry.ZoneRedundancy.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewRegistry(ctx, "registry", &containerregistry.RegistryArgs{
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &containerregistry.SkuArgs{
 * 				Name: pulumi.String(containerregistry.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			ZoneRedundancy: pulumi.String(containerregistry.ZoneRedundancyEnabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Registry;
 * import com.pulumi.azurenative.containerregistry.RegistryArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registry = new Registry("registry", RegistryArgs.builder()
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .zoneRedundancy("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Registry myRegistry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}
 * ```
 */
public class Registry internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.Registry,
) : KotlinCustomResource(javaResource, RegistryMapper) {
    /**
     * The value that indicates whether the admin user is enabled.
     */
    public val adminUserEnabled: Output<Boolean>?
        get() = javaResource.adminUserEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation date of the container registry in ISO8601 format.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Enable a single data endpoint per region for serving data.
     */
    public val dataEndpointEnabled: Output<Boolean>?
        get() = javaResource.dataEndpointEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of host names that will serve data when dataEndpointEnabled is true.
     */
    public val dataEndpointHostNames: Output<List<String>>
        get() = javaResource.dataEndpointHostNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The encryption settings of container registry.
     */
    public val encryption: Output<EncryptionPropertyResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionPropertyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identity of the container registry.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The URL that can be used to log into the container registry.
     */
    public val loginServer: Output<String>
        get() = javaResource.loginServer().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether to allow trusted Azure services to access a network restricted registry.
     */
    public val networkRuleBypassOptions: Output<String>?
        get() = javaResource.networkRuleBypassOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network rule set for a container registry.
     */
    public val networkRuleSet: Output<NetworkRuleSetResponse>?
        get() = javaResource.networkRuleSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkRuleSetResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The policies for a container registry.
     */
    public val policies: Output<PoliciesResponse>?
        get() = javaResource.policies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of private endpoint connections for a container registry.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the container registry at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Whether or not public network access is allowed for the container registry.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the container registry.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The status of the container registry at the time the operation was called.
     */
    public val status: Output<StatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                statusResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether or not zone redundancy is enabled for this container registry
     */
    public val zoneRedundancy: Output<String>?
        get() = javaResource.zoneRedundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RegistryMapper : ResourceMapper<Registry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.Registry::class == javaResource::class

    override fun map(javaResource: Resource): Registry = Registry(
        javaResource as
            com.pulumi.azurenative.containerregistry.Registry,
    )
}

/**
 * @see [Registry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Registry].
 */
public suspend fun registry(name: String, block: suspend RegistryResourceBuilder.() -> Unit):
    Registry {
    val builder = RegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Registry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registry(name: String): Registry {
    val builder = RegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
