@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether or not public network access is allowed for the container registry.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
