@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication mode which determines the source registry login scope. The credentials for the source registry
 * will be generated using the given scope. These credentials will be used to login to
 * the source registry during the run.
 */
public enum class SourceRegistryLoginMode(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode> {
    None(com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode.None),
    Default(com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode.Default),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.SourceRegistryLoginMode):
            SourceRegistryLoginMode =
            SourceRegistryLoginMode.values().first { it.javaValue == javaType }
    }
}
