@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ArgumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a run argument.
 * @property isSecret Flag to indicate whether the argument represents a secret and want to be removed from build logs.
 * @property name The name of the argument.
 * @property value The value of the argument.
 */
public data class ArgumentArgs(
    public val isSecret: Output<Boolean>? = null,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ArgumentArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ArgumentArgs =
        com.pulumi.azurenative.containerregistry.inputs.ArgumentArgs.builder()
            .isSecret(isSecret?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArgumentArgs].
 */
@PulumiTagMarker
public class ArgumentArgsBuilder internal constructor() {
    private var isSecret: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Flag to indicate whether the argument represents a secret and want to be removed from build logs.
     */
    @JvmName("qldlnvhamqbwagwu")
    public suspend fun isSecret(`value`: Output<Boolean>) {
        this.isSecret = value
    }

    /**
     * @param value The name of the argument.
     */
    @JvmName("xuqeyykhbgcoghna")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the argument.
     */
    @JvmName("chsmvjyrsmgbennt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Flag to indicate whether the argument represents a secret and want to be removed from build logs.
     */
    @JvmName("myesdcfaxbxibpkl")
    public suspend fun isSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecret = mapped
    }

    /**
     * @param value The name of the argument.
     */
    @JvmName("hrnldsneswxwtaen")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the argument.
     */
    @JvmName("ruhvefncgnwdflss")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ArgumentArgs = ArgumentArgs(
        isSecret = isSecret,
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
