@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.CredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The parameters that describes a set of credentials that will be used when a run is invoked.
 * @property customRegistries Describes the credential parameters for accessing other custom registries. The key
 * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
 * the value of the item will be the registry credentials for accessing the registry.
 * @property sourceRegistry Describes the credential parameters for accessing the source registry.
 */
public data class CredentialsArgs(
    public val customRegistries: Output<Map<String, CustomRegistryCredentialsArgs>>? = null,
    public val sourceRegistry: Output<SourceRegistryCredentialsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.CredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.CredentialsArgs =
        com.pulumi.azurenative.containerregistry.inputs.CredentialsArgs.builder()
            .customRegistries(
                customRegistries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .sourceRegistry(
                sourceRegistry?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [CredentialsArgs].
 */
@PulumiTagMarker
public class CredentialsArgsBuilder internal constructor() {
    private var customRegistries: Output<Map<String, CustomRegistryCredentialsArgs>>? = null

    private var sourceRegistry: Output<SourceRegistryCredentialsArgs>? = null

    /**
     * @param value Describes the credential parameters for accessing other custom registries. The key
     * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     * the value of the item will be the registry credentials for accessing the registry.
     */
    @JvmName("pygbjfidkvfysldi")
    public suspend fun customRegistries(`value`: Output<Map<String, CustomRegistryCredentialsArgs>>) {
        this.customRegistries = value
    }

    /**
     * @param value Describes the credential parameters for accessing the source registry.
     */
    @JvmName("wylmbekbejbqnaru")
    public suspend fun sourceRegistry(`value`: Output<SourceRegistryCredentialsArgs>) {
        this.sourceRegistry = value
    }

    /**
     * @param value Describes the credential parameters for accessing other custom registries. The key
     * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     * the value of the item will be the registry credentials for accessing the registry.
     */
    @JvmName("lufgkxgslfqtfsbe")
    public suspend fun customRegistries(`value`: Map<String, CustomRegistryCredentialsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRegistries = mapped
    }

    /**
     * @param argument Describes the credential parameters for accessing other custom registries. The key
     * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     * the value of the item will be the registry credentials for accessing the registry.
     */
    @JvmName("vimufsybpcxlswfp")
    public suspend fun customRegistries(
        vararg
        argument: Pair<String, suspend CustomRegistryCredentialsArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                CustomRegistryCredentialsArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.customRegistries = mapped
    }

    /**
     * @param values Describes the credential parameters for accessing other custom registries. The key
     * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     * the value of the item will be the registry credentials for accessing the registry.
     */
    @JvmName("mivawwpekabboypt")
    public fun customRegistries(vararg values: Pair<String, CustomRegistryCredentialsArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRegistries = mapped
    }

    /**
     * @param value Describes the credential parameters for accessing the source registry.
     */
    @JvmName("xbmngbwbkypyxceo")
    public suspend fun sourceRegistry(`value`: SourceRegistryCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegistry = mapped
    }

    /**
     * @param argument Describes the credential parameters for accessing the source registry.
     */
    @JvmName("wvcipkjtsnquujbs")
    public suspend
    fun sourceRegistry(argument: suspend SourceRegistryCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = SourceRegistryCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceRegistry = mapped
    }

    internal fun build(): CredentialsArgs = CredentialsArgs(
        customRegistries = customRegistries,
        sourceRegistry = sourceRegistry,
    )
}
